/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.stacks.AEKey;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.client.gui.widget.NumberInputField;
import com.glodblock.github.extendedae.container.ContainerThresholdLevelEmitter;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class GuiThresholdLevelEmitter
extends UpgradeableScreen<ContainerThresholdLevelEmitter> {
    private final SettingToggleButton<RedstoneMode> redstoneMode = new ServerSettingToggleButton(Settings.REDSTONE_EMITTER, (Enum)RedstoneMode.LOW_SIGNAL);
    private final SettingToggleButton<FuzzyMode> fuzzyMode = new ServerSettingToggleButton(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
    private final NumberInputField upperLevel;
    private final NumberInputField lowerLevel;

    public GuiThresholdLevelEmitter(ContainerThresholdLevelEmitter menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)this.redstoneMode);
        this.addToLeftToolbar((Button)this.fuzzyMode);
        this.upperLevel = new NumberInputField(style, NumberEntryType.of((AEKey)menu.getConfiguredFilter()));
        this.widgets.add("upperLevel", (ICompositeWidget)this.upperLevel);
        this.upperLevel.setTextFieldStyle(style.getWidget("upperLevelInput"));
        this.upperLevel.setLongValue(((ContainerThresholdLevelEmitter)this.menu).upperValue);
        this.upperLevel.setOnChange(this::saveUpperValue);
        this.upperLevel.setOnConfirm(() -> ((GuiThresholdLevelEmitter)this).onClose());
        this.upperLevel.addRemover(this::removeBtn);
        this.lowerLevel = new NumberInputField(style, NumberEntryType.of((AEKey)menu.getConfiguredFilter()));
        this.widgets.add("lowerLevel", (ICompositeWidget)this.lowerLevel);
        this.lowerLevel.setTextFieldStyle(style.getWidget("lowerLevelInput"));
        this.lowerLevel.setLongValue(((ContainerThresholdLevelEmitter)this.menu).lowerValue);
        this.lowerLevel.setOnChange(this::saveLowerValue);
        this.lowerLevel.setOnConfirm(() -> ((GuiThresholdLevelEmitter)this).onClose());
        this.lowerLevel.addRemover(this::removeBtn);
    }

    private void removeBtn(AbstractWidget widget) {
        widget.active = false;
        widget.visible = false;
        this.removeWidget((GuiEventListener)widget);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.upperLevel.setType(NumberEntryType.of((AEKey)((ContainerThresholdLevelEmitter)this.menu).getConfiguredFilter()));
        this.lowerLevel.setType(NumberEntryType.of((AEKey)((ContainerThresholdLevelEmitter)this.menu).getConfiguredFilter()));
        this.fuzzyMode.set((Enum)((ContainerThresholdLevelEmitter)this.menu).getFuzzyMode());
        this.fuzzyMode.setVisibility(((ContainerThresholdLevelEmitter)this.menu).supportsFuzzySearch());
        this.upperLevel.setActive(true);
        this.lowerLevel.setActive(true);
        this.redstoneMode.active = true;
        this.redstoneMode.set((Enum)((ContainerThresholdLevelEmitter)this.menu).getRedStoneMode());
        this.redstoneMode.setVisibility(true);
    }

    private void saveUpperValue() {
        this.upperLevel.getLongValue().ifPresent(((ContainerThresholdLevelEmitter)this.menu)::setUpperValue);
    }

    private void saveLowerValue() {
        this.lowerLevel.getLongValue().ifPresent(((ContainerThresholdLevelEmitter)this.menu)::setLowerValue);
    }
}

