/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ProjectileData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.AutoFireEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.entity.projectile.DraconicArrowEntity;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularBow
extends BowItem
implements IReaperItem,
IModularEnergyItem {
    private final TechLevel techLevel;

    public ModularBow(TechProperties props) {
        super((Item.Properties)props);
        this.techLevel = props.getTechLevel();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "bow", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.RANGED_WEAPON);
        return host;
    }

    @Override
    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack stack, Supplier<ModuleHost> hostSupplier) {
        return new ModularOPStorage(hostSupplier, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, context, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return this.techLevel.index;
    }

    public void onUseTick(Level pLevel, LivingEntity player, ItemStack stack, int count) {
        AutoFireEntity entity;
        if (this.getUseDuration(stack, player) - count >= ModularBow.getChargeTicks(stack, (HolderLookup.Provider)player.registryAccess()) && (entity = (AutoFireEntity)DECapabilities.getHost(stack).getEntitiesByType(ModuleTypes.AUTO_FIRE).map(e -> (AutoFireEntity)e).findAny().orElse(null)) != null && entity.getAutoFireEnabled()) {
            InteractionHand usingHand = player.getUsedItemHand();
            player.stopUsingItem();
            stack.releaseUsing(player.level(), player, 0);
            player.startUsingItem(usingHand);
        }
    }

    private boolean hasInfinity(Level level, ItemStack stack) {
        Registry reg = level.registryAccess().registry(Registries.ENCHANTMENT).orElse(null);
        if (reg != null) {
            Holder holder = reg.getHolder(Enchantments.INFINITY).orElse(null);
            return holder != null && stack.getEnchantmentLevel(holder) > 0;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack bowStack;
        boolean infinity = this.hasInfinity(level, bowStack = player.getItemInHand(hand));
        boolean hasAmmo = infinity || !player.getProjectile(bowStack).isEmpty();
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)bowStack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (EnergyUtils.getEnergyStored((ItemStack)bowStack) < ModularBow.calculateShotEnergy(bowStack, (HolderLookup.Provider)player.registryAccess())) {
            hasAmmo = false;
        }
        if (!player.hasInfiniteMaterials() && !hasAmmo) {
            return InteractionResultHolder.fail((Object)bowStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)bowStack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        boolean infiniteAmmo;
        float powerForTime;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean infinity = this.hasInfinity(level, stack);
        ItemStack ammoStack = player.getProjectile(stack);
        if (ammoStack.isEmpty()) {
            if (infinity) {
                ammoStack = new ItemStack((ItemLike)Items.ARROW);
            } else {
                return;
            }
        }
        int drawTime = this.getUseDuration(stack, entity) - timeLeft;
        if ((drawTime = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (!ammoStack.isEmpty() || infinity ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (ammoStack.isEmpty() && !infinity) {
            return;
        }
        try (ModuleHost host = DECapabilities.getHost(stack);){
            ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
            powerForTime = ModularBow.getPowerForTime(drawTime, stack, (HolderLookup.Provider)player.registryAccess()) * (projData.velocity() + 1.0f);
            if (!((double)powerForTime >= 0.1)) {
                return;
            }
            boolean bl = infiniteAmmo = infinity || player.getAbilities().instabuild || ammoStack.getItem() instanceof ArrowItem && ((ArrowItem)ammoStack.getItem()).isInfinite(ammoStack, stack, (LivingEntity)player);
            if (!level.isClientSide) {
                ArrowItem arrowitem = (ArrowItem)(ammoStack.getItem() instanceof ArrowItem ? ammoStack.getItem() : Items.ARROW);
                AbstractArrow arrowEntity = this.customArrow(arrowitem.createArrow(level, ammoStack, (LivingEntity)player, stack), ammoStack, stack);
                arrowEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, powerForTime * 3.0f, 1.0f - projData.accuracy());
                if (arrowEntity instanceof DraconicArrowEntity) {
                    DraconicArrowEntity deArrow = (DraconicArrowEntity)arrowEntity;
                    deArrow.setTechLevel(this.techLevel);
                    deArrow.setPenetration(projData.penetration());
                    deArrow.setGravComp(projData.antiGrav());
                    if (host.getEntitiesByType(ModuleTypes.PROJ_ANTI_IMMUNE).findAny().isPresent()) {
                        deArrow.setProjectileImmuneOverride(true);
                    }
                }
                if (powerForTime == 1.0f) {
                    arrowEntity.setCritArrow(true);
                }
                arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() * (double)(projData.damage() + 1.0f));
                long energyRequired = (long)((double)EquipCfg.bowBaseEnergy * arrowEntity.getBaseDamage() * (double)powerForTime * 3.0);
                if (this.extractEnergy(player, stack, energyRequired) < energyRequired) {
                    return;
                }
                if (infiniteAmmo) {
                    arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.addFreshEntity((Entity)arrowEntity);
            }
        }
        level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
        if (!infiniteAmmo && !player.getAbilities().instabuild) {
            ammoStack.shrink(1);
            if (ammoStack.isEmpty()) {
                player.getInventory().removeItem(ammoStack);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    protected void shoot(ServerLevel level, LivingEntity entity, InteractionHand hand, ItemStack bow, List<ItemStack> ammoStacks, float power3, float f, boolean fullPower, @Nullable LivingEntity someEntity) {
        super.shoot(level, entity, hand, bow, ammoStacks, power3, f, fullPower, someEntity);
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack stack, ItemStack weaponStack) {
        if (arrow.getType() != EntityType.ARROW && arrow.getType() != EntityType.SPECTRAL_ARROW) {
            return arrow;
        }
        Entity owner = arrow.getOwner();
        if (!(owner instanceof LivingEntity)) {
            return new DraconicArrowEntity(arrow.level(), arrow.getX(), arrow.getY(), arrow.getZ(), stack.copyWithCount(1), weaponStack);
        }
        DraconicArrowEntity newArrow = new DraconicArrowEntity(arrow.level(), (LivingEntity)arrow.getOwner(), stack.copyWithCount(1), weaponStack);
        if (arrow instanceof SpectralArrow) {
            newArrow.setSpectral(((SpectralArrow)arrow).duration);
        }
        return newArrow;
    }

    public static float calculateDamage(ItemStack stack, HolderLookup.Provider provider) {
        try (ModuleHost host = DECapabilities.getHost(stack);){
            ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
            float baseDamage = 2.0f;
            baseDamage *= 1.0f + projData.damage();
            float f = baseDamage *= 3.0f * (1.0f + projData.velocity());
            return f;
        }
    }

    public static long calculateShotEnergy(ItemStack stack, HolderLookup.Provider provider) {
        float damage = ModularBow.calculateDamage(stack, provider);
        return (long)(damage * (float)EquipCfg.bowBaseEnergy);
    }

    public static float getPowerForTime(int time, ItemStack stack, HolderLookup.Provider provider) {
        float fullChargeTime = ModularBow.getChargeTicks(stack, provider);
        float power = (float)time / fullChargeTime;
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        return power;
    }

    public static int getChargeTicks(ItemStack stack, HolderLookup.Provider provider) {
        ModuleHost host = DECapabilities.getHost(stack);
        SpeedData data = host.getModuleData(ModuleTypes.SPEED);
        float speedModifier = data == null ? 0.0f : (float)data.speedMultiplier();
        return (int)Math.ceil(20.0f / (speedModifier += 1.0f));
    }

    @Override
    public void addModularItemInformation(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        IModularEnergyItem.super.addModularItemInformation(stack, context, tooltip, flagIn);
        if (context.level() != null && stack.getCapability(DECapabilities.Host.ITEM) != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.draconicevolution.bow.damage", (Object[])new Object[]{Float.valueOf((float)Math.round(ModularBow.calculateDamage(stack, (HolderLookup.Provider)context.level().registryAccess()) * 10.0f) / 10.0f)}).withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.draconicevolution.bow.energy_per_shot", (Object[])new Object[]{Utils.addCommas((long)ModularBow.calculateShotEnergy(stack, (HolderLookup.Provider)context.level().registryAccess()))}).withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean canBeHurtBy(ItemStack stack, DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0 && entity.pickupDelay != Short.MAX_VALUE) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }
}

