/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.keybinding;

import com.brandon3055.draconicevolution.client.gui.DislocatorGui;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ConfigurableItemGui;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.brandon3055.draconicevolution.network.InputSync;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;

public class KeyInputHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        this.onInput((Player)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        this.onInput((Player)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        double change = event.getScrollDeltaY();
        if (player == null || change == 0.0 || !player.isShiftKeyDown()) {
            return;
        }
        ItemStack item = player.getMainHandItem();
        if (item.is(DEContent.DISLOCATOR_ADVANCED)) {
            event.setCanceled(true);
            DraconicNetwork.sendDislocatorScroll(player.registryAccess(), change < 0.0 ? -1 : 1);
        }
    }

    private void onInput(Player player) {
        boolean newState;
        if (KeyBindings.toolModules.isDown()) {
            DraconicNetwork.sendOpenItemConfig(player.registryAccess(), true);
        } else if (KeyBindings.toolConfig.isDown()) {
            DraconicNetwork.sendOpenItemConfig(player.registryAccess(), false);
        } else if (KeyBindings.toggleFlight.isDown()) {
            if (player.getAbilities().mayfly) {
                if (player.getAbilities().flying) {
                    player.getAbilities().flying = false;
                    player.onUpdateAbilities();
                } else {
                    player.getAbilities().flying = true;
                    if (player.onGround()) {
                        player.setPos(player.getX(), player.getY() + 0.05, player.getZ());
                        player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                    }
                    player.onUpdateAbilities();
                }
            }
        } else if (KeyBindings.toggleMagnet.isDown()) {
            DraconicNetwork.sendToggleMagnets(player.registryAccess());
        } else if (KeyBindings.dislocatorTeleport.isDown()) {
            DraconicNetwork.sendDislocatorMessage(player.registryAccess(), 11, output -> {});
        } else if (KeyBindings.dislocatorBlink.isDown()) {
            DraconicNetwork.sendDislocatorMessage(player.registryAccess(), 12, output -> {});
        } else if (KeyBindings.dislocatorUp.isDown()) {
            DraconicNetwork.sendDislocatorMessage(player.registryAccess(), 13, output -> output.writeBoolean(false));
        } else if (KeyBindings.dislocatorDown.isDown()) {
            DraconicNetwork.sendDislocatorMessage(player.registryAccess(), 13, output -> output.writeBoolean(true));
        } else if (KeyBindings.dislocatorGui.isDown()) {
            ItemStack stack = DislocatorAdvanced.findDislocator(player);
            if (!stack.isEmpty()) {
                Minecraft.getInstance().setScreen((Screen)new DislocatorGui.Screen(stack.getHoverName(), player));
            }
        } else if (KeyBindings.placeItem.isDown()) {
            DraconicNetwork.sendPlaceItem(player.registryAccess());
        }
        Options options = Minecraft.getInstance().options;
        boolean oldState = InputSync.getSprintState(player.getUUID());
        boolean bl = newState = options.keyUp.isDown() && options.keySprint.isDown();
        if (oldState != newState) {
            InputSync.setSprintState(player.getUUID(), newState);
            DraconicNetwork.sendSprintState(player.registryAccess(), newState);
        }
    }

    private int previouseSlot(int i, int c) {
        if (c > 0 && c < 8) {
            return c + i;
        }
        if (c == 0 && i < 0) {
            return 8;
        }
        if (c == 8 && i > 0) {
            return 0;
        }
        return c + i;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void priorityKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && event.getAction() == 1) {
            ConfigurableItemGui.checkKeybinding(event.getKey(), event.getScanCode());
        }
    }
}

