/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiScrolling;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.ForegroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Rectangle;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ConfigurableItemGui;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyElement;
import com.brandon3055.draconicevolution.inventory.ConfigurableItemMenu;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyContainer
extends GuiManipulable {
    private static String DEFAULT_NAME = "Group";
    private static MessageSignature PRESET_CHAT_SIG = Utils.uuidToSig((UUID)UUID.fromString("929cb525-22f3-4685-aa09-2c275d057f72"));
    private final boolean isGroup;
    protected String boundKey = "";
    protected KeyModifier modifier = KeyModifier.NONE;
    private boolean binding = false;
    private boolean customHeight = false;
    private boolean collapsed = false;
    protected boolean presetMode = false;
    protected boolean globalKeyBind = false;
    private GuiButton applyPreset;
    private GuiTextField groupName;
    private PropertyElement dropTargetElement = null;
    private GuiScrolling scrollElement;
    private PropertyContainer dropTarget = null;
    private GuiElement<?> cancelZone = null;
    private final ConfigurableItemGui gui;
    private Rectangle prevBounds = Rectangle.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public LinkedList<PropertyData> dataList = new LinkedList();
    public List<PropertyElement> propertyElements = new ArrayList<PropertyElement>();

    public PropertyContainer(@NotNull GuiParent<?> parent, @Nullable ConfigurableItemGui gui, boolean isGroup) {
        super(parent);
        this.enableCursors(true);
        this.constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0));
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(22 + (isGroup ? 15 : 2))));
        this.gui = gui;
        this.isGroup = isGroup;
        if (isGroup) {
            this.addResizeHandles(3, true);
        } else {
            this.addLeftHandle(1);
            this.addRightHandle(1);
        }
        this.constructElement();
        this.setupDragAndDrop();
        Rectangle min = this.getMinSize();
        Rectangle max = this.getMaxSize();
        if ((double)(this.yMax - this.yMin) < min.height()) {
            this.yMax = this.yMin + (int)min.height();
        }
        if ((double)(this.yMax - this.yMin) > max.height()) {
            this.yMax = this.yMin + (int)max.height();
        }
        if (this.yMax > this.scaledScreenHeight()) {
            this.yMax = this.scaledScreenHeight();
        }
        if ((double)(this.xMax - this.xMin) < min.width()) {
            this.xMax = this.xMin + (int)min.width();
        }
        if ((double)(this.xMax - this.xMin) > max.width()) {
            this.xMax = this.xMin + (int)max.width();
        }
        if (this.xMax > this.scaledScreenWidth()) {
            this.xMax = this.scaledScreenWidth();
        }
        if (gui != null) {
            gui.newContainer(this);
            this.setResetOnUiInit(false);
            this.setEnabled(() -> gui.advancedUI || DEConfig.configUiEnableAdvancedXOver);
        }
    }

    public void onScreenInit(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        super.onScreenInit(mc, font, screenWidth, screenHeight);
        this.validatePosition(false);
    }

    public PropertyContainer setPos(int xPos, int yPos) {
        int width = this.xMax - this.xMin;
        int height = this.yMax - this.yMin;
        this.xMin = xPos;
        this.xMax = this.xMin + width;
        this.yMin = yPos;
        this.yMax = this.yMin + height;
        return this;
    }

    private void constructElement() {
        GuiElement root = this.getContentElement();
        new DropZoneRender((GuiParent<?>)root);
        GuiTexture background = new GuiTexture((GuiParent)root, BCGuiTextures.themedGetter((String)"borderless_bg_dynamic_small")).dynamicTexture().setColour(() -> this.isMoving() ? 0x60FFFFFF : -1);
        Constraints.bind((ConstrainedGeometry)background, (ConstrainedGeometry)root);
        this.scrollElement = (GuiScrolling)((GuiScrolling)((GuiScrolling)((GuiScrolling)new GuiScrolling((GuiParent)root).setEnabled(() -> !this.isGroup || this.scrollElement.ySize() > 10.0 && !this.applyPreset.isEnabled())).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)(this.isGroup ? 3.0 : 1.0)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)(this.isGroup ? 12.0 : 1.0)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)(this.isGroup ? -3.0 : -1.0)));
        this.scrollElement.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), () -> this.isGroup ? (this.scrollElement.hiddenSize(Axis.Y) > 0.0 ? -8.0 : -3.0) : -1.0));
        this.scrollElement.getContentElement().constrain(GeoParam.WIDTH, null);
        this.scrollElement.getContentElement().constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.scrollElement.get(GeoParam.RIGHT)));
        GuiRectangle contentBorder = ((GuiRectangle)new GuiRectangle((GuiParent)root).setEnabled(() -> this.isGroup && this.getContentElement().ySize() - 4.0 - 9.0 > 0.0 && !this.applyPreset.isEnabled())).setShadeBottomRight(() -> (BCConfig.darkMode ? 0x5B5B5B : 0xFFFFFF) | (this.isMoving() ? 0x60000000 : -16777216)).setShadeTopLeft(() -> (BCConfig.darkMode ? 0x282828 : 0x505050) | (this.isMoving() ? 0x60000000 : -16777216)).setShadeCornersAuto();
        Constraints.bind((ConstrainedGeometry)contentBorder, (ConstrainedGeometry)this.scrollElement, (double)-1.0);
        contentBorder.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.scrollElement.get(GeoParam.RIGHT), () -> this.scrollElement.hiddenSize(Axis.Y) > 0.0 ? 6.0 : 1.0));
        GuiSlider bar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider((GuiParent)root, Axis.Y).setEnabled(() -> this.scrollElement.hiddenSize(Axis.Y) > 0.0)).setSliderState(this.scrollElement.scrollState(Axis.Y)).setScrollableElement((GuiElement)this.scrollElement).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.scrollElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.scrollElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)contentBorder.get(GeoParam.RIGHT), (double)-1.0));
        bar.installSlider((GuiElement)new GuiRectangle((GuiParent)bar).fill(() -> BCConfig.darkMode ? -2130706433 : -1157627904)).bindSliderWidth().bindSliderLength();
        GuiButton toggleHidden = (GuiButton)((GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)root, 8, () -> BCGuiTextures.getThemed((String)(this.collapsed ? "expand_content" : "collapse_content"))).setEnabled(this.isGroup)).onPress(this::toggleCollapsed).setTooltipSingle(() -> this.presetMode ? Component.translatable((String)"gui.draconicevolution.item_config.edit_preset.info") : Component.translatable((String)("gui.draconicevolution.item_config." + (this.collapsed ? "expand_group" : "collapse_group") + ".info")));
        Constraints.placeInside((ConstrainedGeometry)toggleHidden, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)2.0, (double)2.0);
        GuiButton dragZone = ((GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)root, 8, () -> Screen.hasShiftDown() ? BCGuiTextures.get((String)"dark/copy") : (Screen.hasControlDown() ? BCGuiTextures.get((String)"delete") : BCGuiTextures.getThemed((String)"reposition"))).setTooltip(() -> this.isMoving() ? Collections.emptyList() : Collections.singletonList(Component.translatable((String)(Screen.hasShiftDown() ? "gui.draconicevolution.item_config.copy_group.info" : (Screen.hasControlDown() ? "gui.draconicevolution.item_config.delete_group.info" : "gui.draconicevolution.item_config.move_group.info")))))).onClick(() -> {
            if (Screen.hasShiftDown()) {
                this.duplicateContainer((HolderLookup.Provider)root.mc().player.registryAccess());
            } else if (Screen.hasControlDown()) {
                this.deleteContainer();
            } else {
                this.startDragging();
            }
        });
        Constraints.placeInside((ConstrainedGeometry)dragZone, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-2.0, (double)2.0);
        GuiButton togglePreset = ((GuiButton)((GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)root, 8, BCGuiTextures.themedGetter((String)"preset_icon")).setEnabled(this.isGroup)).setTooltip(new Component[]{Component.translatable((String)"gui.draconicevolution.item_config.toggle_preset.info")})).onClick(this::togglePreset);
        Constraints.placeOutside((ConstrainedGeometry)togglePreset, (ConstrainedGeometry)dragZone, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)-2.0, (double)0.0);
        Constraints.bind((ConstrainedGeometry)ConfigurableItemGui.TOOLKIT.shadedBorder((GuiParent)togglePreset).setEnabled(() -> this.presetMode), (ConstrainedGeometry)togglePreset, (double)-1.0);
        GuiButton globalBinding = ((GuiButton)((GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)root, 8, BCGuiTextures.themedGetter((String)"global_key_icon")).setTooltip(new Component[]{Component.translatable((String)"gui.draconicevolution.item_config.toggle_global_binding.info")})).setEnabled(() -> !this.boundKey.isEmpty() && this.presetMode)).onClick(() -> {
            this.globalKeyBind = !this.globalKeyBind;
            this.saveGui();
        });
        Constraints.placeOutside((ConstrainedGeometry)globalBinding, (ConstrainedGeometry)togglePreset, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)-2.0, (double)0.0);
        Constraints.bind((ConstrainedGeometry)ConfigurableItemGui.TOOLKIT.shadedBorder((GuiParent)globalBinding).setEnabled(() -> this.globalKeyBind), (ConstrainedGeometry)globalBinding, (double)-1.0);
        this.groupName = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField((GuiParent)root).setEnabled(this.isGroup)).setTextState(TextState.simpleState((String)DEFAULT_NAME, s -> this.saveGui())).setTextColor(GuiToolkit.Palette.BG::text).setShadow(() -> BCConfig.darkMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)toggleHidden.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)globalBinding.get(GeoParam.LEFT), (double)-1.0));
        GuiButton bindButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)ConfigurableItemGui.TOOLKIT.createBorderlessButton((GuiParent)this, this::getBindingName).setEnabled(this.isGroup)).setTooltip(new Component[]{Component.translatable((String)"gui.draconicevolution.item_config.set_key_bind.info")})).onPress(() -> {
            this.boundKey = "";
            this.modifier = KeyModifier.NONE;
            this.binding = !this.binding;
            this.saveGui();
        }).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)11.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> Math.min((root.xSize() - 3.0) / 2.0, (double)(this.font().width((FormattedText)this.getBindingName()) + 6))))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-2.0));
        this.applyPreset = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)ConfigurableItemGui.TOOLKIT.createBorderlessButton((GuiParent)this, (Component)Component.translatable((String)"gui.draconicevolution.item_config.apply_preset")).setEnabled(() -> this.presetMode && this.collapsed)).onPress(this::applyPreset).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)11.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)bindButton.get(GeoParam.LEFT)));
        this.applyPreset.getLabel().setTextColour(() -> GuiToolkit.Palette.Ctrl.textH((boolean)this.applyPreset.isMouseOver()));
        bindButton.setEnabled(() -> ((GuiButton)this.applyPreset).isEnabled());
        Constraints.bind((ConstrainedGeometry)((GuiText)new GuiText((GuiParent)contentBorder, (Component)Component.translatable((String)"gui.draconicevolution.item_config.drop_prop_here")).setEnabled(() -> this.dataList.isEmpty())).setTextColour(GuiToolkit.Palette.BG::text).setShadow(BCConfig.darkMode), (ConstrainedGeometry)contentBorder);
    }

    private void setupDragAndDrop() {
        this.setOnMovedCallback(finished -> {
            double mouseX = this.getModularGui().computeMouseX();
            double mouseY = this.getModularGui().computeMouseY();
            if (finished.booleanValue()) {
                if (this.dropTarget != null && !this.dataList.isEmpty()) {
                    if (this.dropTarget.isGroup) {
                        this.getParent().removeChild((GuiElement)this);
                        this.gui.propertyContainers.remove((Object)this);
                        boolean before = this.dropTargetElement != null && mouseY < this.dropTargetElement.yMin() + this.dropTargetElement.ySize() / 2.0;
                        this.dropTarget.addProperty(this.dataList.get(0), this.dropTargetElement == null ? null : this.dropTargetElement.data, before);
                    } else if (this.dropTargetElement != null) {
                        this.getParent().removeChild((GuiElement)this.dropTarget);
                        this.getParent().removeChild((GuiElement)this);
                        this.gui.propertyContainers.remove((Object)this.dropTarget);
                        this.gui.propertyContainers.remove((Object)this);
                        this.gui.cancelAutoPos();
                        PropertyContainer newGroup = new PropertyContainer(this.getParent(), this.gui, true);
                        this.gui.resumeAutoPos();
                        newGroup.setPos((int)this.dropTargetElement.xMin() - 2, (int)this.dropTargetElement.yMin() - 12);
                        newGroup.xMax = (int)((double)newGroup.xMin + this.dropTargetElement.xSize() + 3.0);
                        newGroup.validatePosition(false);
                        newGroup.addProperty(this.dropTargetElement.data);
                        newGroup.addProperty(this.dataList.get(0), this.dropTargetElement.data, mouseY < this.dropTargetElement.yMin() + this.dropTargetElement.ySize() / 2.0);
                    } else {
                        this.dropTarget = null;
                    }
                }
                this.saveGui();
            } else if (this.dropTarget != null) {
                if (!this.dropTarget.getContentElement().isMouseOver()) {
                    this.dropTarget = null;
                    this.dropTargetElement = null;
                } else {
                    this.dropTargetElement = this.dropTarget.propertyElements.stream().filter(GuiElement::isMouseOver).findAny().orElse(null);
                }
            } else {
                for (PropertyContainer element : this.gui.propertyContainers) {
                    if (element == this) continue;
                    Rectangle other = element.getContentElement().getRectangle();
                    if (this.isGroup || !GuiRender.isInRect((double)(other.x() + 8.0), (double)(other.y() + 8.0), (double)(other.width() - 16.0), (double)(other.height() - 16.0), (double)mouseX, (double)mouseY)) continue;
                    this.dropTarget = element;
                    this.dropTargetElement = element.propertyElements.stream().filter(GuiElement::isMouseOver).findAny().orElse(null);
                }
            }
        });
        this.setOnResizedCallback(finished -> {
            if (!finished.booleanValue()) {
                return;
            }
            this.customHeight = this.yMax - this.yMin != (int)this.getMaxSize().height();
        });
        GuiManipulable.PositionRestraint screenRestraint = this.positionRestraint;
        this.setPositionRestraint(draggable -> {
            screenRestraint.restrainPosition(draggable);
            if (!DEConfig.configUiEnableSnapping) {
                return;
            }
            Rectangle newPos = this.getContentElement().getRectangle();
            Rectangle originalPos = Rectangle.create((double)newPos.x(), (double)newPos.y(), (double)newPos.width(), (double)newPos.height());
            for (PropertyContainer element : this.gui.propertyContainers) {
                int move;
                Rectangle other;
                if (element == this || !newPos.intersects(other = element.getContentElement().getRectangle()) || this.prevBounds.intersects(other)) continue;
                if (!this.isGroup && GuiRender.isInRect((double)(other.x() + 8.0), (double)(other.y() + 8.0), (double)(other.width() - 16.0), (double)(other.height() - 16.0), (double)this.getModularGui().computeMouseX(), (double)this.getModularGui().computeMouseY())) {
                    this.setPos((int)originalPos.x(), (int)originalPos.y());
                    return;
                }
                Rectangle intersection = newPos.intersect(other);
                if (intersection.width() / newPos.width() < intersection.height() / newPos.height()) {
                    move = (int)(intersection.width() * (double)(this.prevBounds.x() < other.x() ? -1 : 1));
                    this.xMin += move;
                    this.xMax += move;
                    continue;
                }
                move = (int)(intersection.height() * (double)(this.prevBounds.y() < other.y() ? -1 : 1));
                this.yMin += move;
                this.yMax += move;
            }
        });
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.isMoving() || this.isResizing()) {
            this.gui.root.clearGeometryCache();
            this.prevBounds = Rectangle.create((double)this.xMin, (double)this.yMin, (double)(this.xMax - this.xMin), (double)(this.yMax - this.yMin));
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.isMoving() && (this.gui.deleteZone.isMouseOver() || this.cancelZone != null && this.cancelZone.isMouseOver())) {
            this.deleteContainer();
            return true;
        }
        this.cancelZone = null;
        return super.mouseReleased(mouseX, mouseY, button, consumed);
    }

    public void addProperty(PropertyData data) {
        this.addProperty(data, null, false);
    }

    public void addProperty(PropertyData data, @Nullable PropertyData relativeTo, boolean addBefore) {
        if (relativeTo == null || !this.dataList.contains(relativeTo)) {
            this.dataList.add(data);
        } else if (addBefore) {
            this.dataList.add(this.dataList.indexOf(relativeTo), data);
        } else {
            this.dataList.add(this.dataList.indexOf(relativeTo) + 1, data);
        }
        boolean willResize = this.ySize() == this.getMaxSize().height();
        this.reloadPropertyList(willResize);
    }

    private void reloadPropertyList(boolean resize) {
        this.propertyElements.forEach(e -> e.getParent().removeChild((GuiElement)e));
        this.propertyElements.clear();
        GuiElement content = this.scrollElement.getContentElement();
        double yOffset = 0.0;
        int i = 0;
        for (PropertyData data : this.dataList) {
            PropertyElement element = (PropertyElement)((PropertyElement)((PropertyElement)this.createPropertyElement(content, data, i).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)content.get(GeoParam.TOP), (double)yOffset));
            this.propertyElements.add(element);
            yOffset += element.ySize();
            ++i;
        }
    }

    private PropertyElement createPropertyElement(GuiElement<?> parent, PropertyData data, int index) {
        PropertyElement element = new PropertyElement((GuiParent<?>)parent, data, this.gui, index, true);
        element.setOpacitySupplier(() -> this.isMoving() ? 0x60000000 : -16777216);
        element.setEnableToolTip(() -> !this.isMoving() && !this.isResizing());
        data.setChangeListener(() -> {
            if (!this.presetMode) {
                this.applyData(data);
                this.gui.updateAnimations.add(new ConfigurableItemGui.UpdateAnim(data));
            }
        });
        GuiButton dragZone = (GuiButton)ConfigurableItemGui.TOOLKIT.createIconButton((GuiParent)element, 8, () -> Screen.hasShiftDown() ? BCGuiTextures.get((String)"dark/copy") : (Screen.hasControlDown() ? BCGuiTextures.get((String)"delete") : BCGuiTextures.get((String)"reposition_gray"))).setTooltip(() -> this.isMoving() ? Collections.emptyList() : Collections.singletonList(Component.translatable((String)(Screen.hasShiftDown() ? "gui.draconicevolution.item_config.copy_group.info" : (Screen.hasControlDown() ? "gui.draconicevolution.item_config.delete_group.info" : "gui.draconicevolution.item_config.move_group.info")))));
        Constraints.placeInside((ConstrainedGeometry)dragZone, (ConstrainedGeometry)element, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-1.0, (double)1.0);
        if (!this.isGroup) {
            dragZone.setEnabled(false);
            this.setMoveHandle((GuiElement)dragZone);
            this.setEnabled(() -> !(!this.gui.advancedUI && !DEConfig.configUiEnableAdvancedXOver || !DEConfig.configUiShowUnavailable && !data.isGlobal && !data.isPropertyAvailable()));
        } else {
            element.setEnabled(() -> DEConfig.configUiShowUnavailable || data.isGlobal || data.isPropertyAvailable());
            dragZone.onClick(() -> {
                if (!Screen.hasShiftDown()) {
                    this.dataList.remove(data);
                    this.reloadPropertyList(false);
                }
                if (Screen.hasShiftDown() || !Screen.hasControlDown()) {
                    PropertyContainer copy = new PropertyContainer((GuiParent<?>)this.gui.root, this.gui, false);
                    copy.addProperty(data.copy());
                }
            });
        }
        return element;
    }

    public void tick(double mouseX, double mouseY) {
        int targetHeight;
        super.tick(mouseX, mouseY);
        if (!(this.isMoving() || this.isResizing() || this.customHeight || this.yMax - this.yMin == (targetHeight = (int)this.getMaxSize().height()))) {
            this.yMax = this.yMin + targetHeight;
            this.validatePosition(false);
            this.saveGui();
        }
    }

    public Rectangle getMinSize() {
        return Rectangle.create((double)0.0, (double)0.0, (double)80.0, (double)(22 + (this.isGroup ? 15 : 2)));
    }

    public Rectangle getMaxSize() {
        int count = DEConfig.configUiShowUnavailable ? this.dataList.size() : (int)this.dataList.stream().filter(PropertyData::isPropertyAvailable).count();
        int maxY = MathHelper.clip((int)(count * 22 + (this.isGroup ? 15 : 2)), (int)24, (int)300);
        return Rectangle.create((double)0.0, (double)0.0, (double)250.0, (double)(this.collapsed ? (this.presetMode ? 25.0 : 12.0) : (double)maxY));
    }

    public void startDragging() {
        super.startDragging();
        ((GuiElement)this.getParent()).bringChildToForeground((GuiElement)this);
        this.gui.propertyContainers.remove((Object)this);
        this.gui.propertyContainers.add(this);
    }

    public void setCancelZone(GuiElement<?> cancelZone) {
        this.cancelZone = cancelZone;
    }

    public void deleteContainer() {
        this.getParent().removeChild((GuiElement)this);
        this.gui.propertyContainers.remove((Object)this);
        this.saveGui();
    }

    public void duplicateContainer(HolderLookup.Provider provider) {
        PropertyContainer newGroup = PropertyContainer.deserialize(this.gui, this.getParent(), this.serialize(provider), provider);
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (this.binding) {
            this.modifier = KeyModifier.NONE;
            if (key == 256) {
                this.boundKey = "";
                this.binding = false;
                this.saveGui();
                return true;
            }
            KeyModifier mods = KeyModifier.getActiveModifier();
            InputConstants.Key input = InputConstants.getKey((int)key, (int)scancode);
            this.boundKey = input.toString();
            if (!mods.matches(input)) {
                this.modifier = mods;
            }
            return true;
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    public boolean keyReleased(int key, int scancode, int modifiers) {
        if (this.binding) {
            this.saveGui();
            this.binding = false;
            return true;
        }
        return super.keyReleased(key, scancode, modifiers);
    }

    private Component getBindingName() {
        if (this.binding) {
            return Component.literal((String)">").append((Component)(this.boundKey.isEmpty() ? Component.literal((String)"   ") : InputConstants.getKey((String)this.boundKey).getDisplayName())).append("<");
        }
        if (this.boundKey.isEmpty()) {
            return Component.translatable((String)"gui.draconicevolution.item_config.not_bound");
        }
        InputConstants.Key keyCode = InputConstants.getKey((String)this.boundKey);
        return this.modifier.getCombinedName(keyCode, () -> ((InputConstants.Key)keyCode).getDisplayName());
    }

    private void togglePreset() {
        this.collapsed = this.presetMode = !this.presetMode;
        this.saveGui();
    }

    private void toggleCollapsed() {
        boolean bl = this.collapsed = !this.collapsed;
        if (!this.collapsed) {
            ((GuiElement)this.getParent()).bringChildToForeground((GuiElement)this);
            this.gui.propertyContainers.remove((Object)this);
            this.gui.propertyContainers.add(this);
        }
        this.saveGui();
    }

    public void applyPreset() {
        this.dataList.forEach(this::applyData);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        List<ItemStack> effectedItems = ConfigurableItemMenu.getStackProviders(ConfigurableItemMenu.getPlayerInventory(player.getInventory())).filter(e -> this.dataList.stream().anyMatch(data -> data.getPropIfApplicable((PropertyProvider)e.value()) != null)).map(Pair::key).toList();
        MutableComponent message = Component.translatable((String)"gui.draconicevolution.item_config.preset_applied.msg", (Object[])new Object[]{Component.literal((String)this.groupName.getValue()).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.BLUE);
        if (effectedItems.isEmpty()) {
            message.append((Component)Component.translatable((String)"gui.draconicevolution.item_config.no_items_for_preset.msg"));
        } else {
            for (int i = 0; i < effectedItems.size(); ++i) {
                ItemStack stack = effectedItems.get(i);
                MutableComponent stackComp = stack.getDisplayName().copy();
                stackComp.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack)));
                message.append((Component)stackComp);
                if (i >= effectedItems.size() - 1) continue;
                message.append(", ");
            }
        }
        BrandonsCore.proxy.sendIndexedMessage((Player)Minecraft.getInstance().player, (Component)message, PRESET_CHAT_SIG);
    }

    private void applyData(PropertyData data) {
        data.sendToServer(this.mc().level.registryAccess());
        if (this.gui != null) {
            this.gui.updateAnimations.add(new ConfigurableItemGui.UpdateAnim(data));
        }
    }

    public void inventoryUpdate() {
        this.dataList.forEach(e -> e.pullData(this.gui.menu, !this.presetMode && !e.isGlobal));
    }

    public CompoundTag serialize(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("group", this.isGroup);
        if (this.isGroup) {
            nbt.putBoolean("preset", this.presetMode);
            nbt.putBoolean("collapsed", this.collapsed);
            nbt.putString("name", this.groupName.getValue());
            nbt.putBoolean("global_key", this.globalKeyBind);
            if (!this.boundKey.isEmpty()) {
                nbt.putString("binding", this.boundKey);
                nbt.putInt("modifier", this.modifier.ordinal());
            }
        }
        nbt.putInt("x_min", this.xMin);
        nbt.putInt("x_max", this.xMax);
        nbt.putInt("y_min", this.yMin);
        nbt.putInt("y_max", this.yMax);
        nbt.putBoolean("custom_height", this.customHeight);
        nbt.put("data", (Tag)this.dataList.stream().map(e -> e.serialize(provider)).collect(Collectors.toCollection(ListTag::new)));
        return nbt;
    }

    public static PropertyContainer deserialize(ConfigurableItemGui gui, GuiParent<?> parent, CompoundTag nbt, HolderLookup.Provider provider) {
        boolean isGroup = nbt.getBoolean("group");
        PropertyContainer container = new PropertyContainer(parent, gui, isGroup);
        if (isGroup) {
            container.presetMode = nbt.getBoolean("preset");
            container.collapsed = nbt.getBoolean("collapsed");
            container.groupName.getTextState().setText(nbt.getString("name"));
            container.boundKey = nbt.getString("binding");
            container.modifier = KeyModifier.values()[nbt.getInt("modifier")];
            container.globalKeyBind = nbt.getBoolean("global_key");
        }
        container.xMin = nbt.getInt("x_min");
        container.xMax = nbt.getInt("x_max");
        container.yMin = nbt.getInt("y_min");
        container.yMax = nbt.getInt("y_max");
        container.customHeight = nbt.getBoolean("custom_height");
        container.dataList.addAll(nbt.getList("data", 10).stream().map(e -> (CompoundTag)e).map(e -> PropertyData.deserialize(e, provider)).filter(Objects::nonNull).toList());
        container.reloadPropertyList(false);
        return container;
    }

    private void saveGui() {
        if (this.gui != null) {
            this.gui.saveInterfaceState();
        }
    }

    public class DropZoneRender
    extends GuiElement<DropZoneRender>
    implements ForegroundRender {
        public DropZoneRender(GuiParent<?> parent) {
            super(parent);
            Constraints.bind((ConstrainedGeometry)this, (ConstrainedGeometry)((GuiElement)parent));
        }

        public void renderForeground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            if (PropertyContainer.this.dropTarget != null) {
                if (PropertyContainer.this.dropTargetElement != null) {
                    Rectangle rect = PropertyContainer.this.dropTargetElement.getRectangle();
                    if (mouseY < rect.y() + rect.height() / 2.0) {
                        render.gradientFillV(rect.x(), rect.y(), rect.x() + rect.width(), rect.y() + 6.0, -16711936, 65280);
                    } else {
                        render.gradientFillV(rect.x(), rect.y() + rect.height() - 6.0, rect.x() + rect.width(), rect.y() + rect.height(), 65280, -16711936);
                    }
                } else {
                    GuiElement ce = PropertyContainer.this.dropTarget.getContentElement();
                    render.gradientFillV(ce.xMin() + 3.0, ce.yMin() + 13.0, ce.xMax() - 3.0, ce.yMin() + 15.0, -16711936, 65280);
                    render.gradientFillV(ce.xMin() + 3.0, ce.yMax() - 6.0, ce.xMax() - 3.0, ce.yMax() - 3.0, 65280, -16711936);
                }
            }
        }
    }
}

