/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class NightVisionEntity
extends ModuleEntity<AutoFeedData> {
    private BooleanProperty enabled = new BooleanProperty("night_vision.enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED).setChangeListener((stack, prop) -> {
        this.wasJustDisabled = !prop.getValue();
    });
    private IntegerProperty enableInLight = new IntegerProperty("night_vision.light_level", 15).min(0).max(15).setFormatter(ConfigProperty.IntegerFormatter.RAW);
    private boolean wasJustDisabled = false;
    private boolean appliedByModule = false;
    private int tick;
    private int disableTimer = 0;
    public static final Codec<NightVisionEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)BooleanProperty.CODEC.fieldOf("enabled").forGetter(e -> e.enabled), (App)IntegerProperty.CODEC.fieldOf("enable_in_light").forGetter(e -> e.enableInLight)).apply((Applicative)builder, NightVisionEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NightVisionEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, BooleanProperty.STREAM_CODEC, e -> e.enabled, IntegerProperty.STREAM_CODEC, e -> e.enableInLight, NightVisionEntity::new);

    public NightVisionEntity(Module<AutoFeedData> module) {
        super(module);
    }

    NightVisionEntity(Module<?> module, int gridX, int gridY, BooleanProperty enabled, IntegerProperty enableInLight) {
        super(module, gridX, gridY);
        this.enabled = enabled;
        this.enableInLight = enableInLight;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new NightVisionEntity(this.module, this.getGridX(), this.getGridY(), this.enabled.copy(), this.enableInLight.copy());
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        super.getEntityProperties(properties);
        properties.add(this.enabled);
        properties.add(this.enableInLight);
    }

    @Override
    public void tick(ModuleContext context) {
        boolean shouldApply;
        ServerPlayer player;
        if (this.tick++ % 20 != 0 || !(context instanceof StackModuleContext)) {
            return;
        }
        StackModuleContext ctx = (StackModuleContext)context;
        LivingEntity livingEntity = ctx.getEntity();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).level().isClientSide() || !ctx.isEquipped()) {
            return;
        }
        if (!this.enabled.getValue()) {
            if (this.wasJustDisabled && this.appliedByModule) {
                player.removeEffect(MobEffects.NIGHT_VISION);
                this.appliedByModule = false;
                this.wasJustDisabled = false;
                this.markDirty();
            }
            return;
        }
        IOPStorage opStorage = ctx.getOpStorage();
        if (opStorage == null || opStorage.getOPStored() < (long)EquipCfg.nightVisionEnergy * 20L) {
            if (this.appliedByModule && this.disableTimer++ >= 3) {
                player.removeEffect(MobEffects.NIGHT_VISION);
                this.appliedByModule = false;
                this.markDirty();
            }
            return;
        }
        boolean bl = shouldApply = player.level().getRawBrightness(player.blockPosition(), 0) <= this.enableInLight.getValue();
        if (shouldApply) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 302, 0, false, false));
            ctx.getOpStorage().modifyEnergyStored((long)(-EquipCfg.nightVisionEnergy) * 20L);
            this.appliedByModule = true;
            this.disableTimer = 0;
        } else if (this.appliedByModule && this.disableTimer++ >= 3) {
            player.removeEffect(MobEffects.NIGHT_VISION);
            this.appliedByModule = true;
        }
        this.markDirty();
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)this.enabled.copy());
        stack.set(ItemData.INT_ITEM_PROP_1, (Object)this.enableInLight.copy());
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.enabled = ((BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_1, (Object)this.enabled)).copy();
        this.enableInLight = ((IntegerProperty)stack.getOrDefault(ItemData.INT_ITEM_PROP_1, (Object)this.enableInLight)).copy();
    }
}

