/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.ChemicalIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.handler.ChemicalComponentHandler;
import java.util.Collections;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;

public record ChemicalRequirement(RequirementIOMode mode, Chemical chemical, long amount, String tank) implements IRequirement<ChemicalComponentHandler>,
IJEIIngredientRequirement<ChemicalStack>
{
    public static NamedCodec<ChemicalRequirement> CODEC = NamedCodec.record(chemicalRequirementInstance -> chemicalRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(requirement -> requirement.mode), (App)NamedCodec.registrar((Registry)MekanismAPI.CHEMICAL_REGISTRY).fieldOf("chemical").forGetter(requirement -> requirement.chemical), (App)NamedCodec.LONG.fieldOf("amount").forGetter(requirement -> requirement.amount), (App)NamedCodec.STRING.optionalFieldOf("tank", (Object)"").forGetter(requirement -> requirement.tank)).apply((Applicative)chemicalRequirementInstance, ChemicalRequirement::new), (String)"Chemical requirement");

    public RequirementType<ChemicalRequirement> getType() {
        return Registration.CHEMICAL_REQUIREMENT.get();
    }

    public MachineComponentType getComponentType() {
        return Registration.CHEMICAL_MACHINE_COMPONENT.get();
    }

    public boolean test(ChemicalComponentHandler handler, ICraftingContext context) {
        long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return handler.getChemicalAmount(this.tank, this.chemical) >= amount;
        }
        return handler.getSpaceForChemical(this.tank, this.chemical) >= amount;
    }

    public RequirementIOMode getMode() {
        return this.mode;
    }

    public void gatherRequirements(IRequirementList<ChemicalComponentHandler> list) {
        if (this.mode == RequirementIOMode.INPUT) {
            list.processOnStart(this::processInput);
        } else {
            list.processOnEnd(this::processOutput);
        }
    }

    private CraftingResult processInput(ChemicalComponentHandler handler, ICraftingContext context) {
        long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
        if (!this.test(handler, context)) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinerymekanism.requirements.chemical.error.input", (Object[])new Object[]{Component.translatable((String)this.chemical.getTranslationKey()), amount}));
        }
        handler.removeFromInputs(this.tank, this.chemical, amount);
        return CraftingResult.success();
    }

    private CraftingResult processOutput(ChemicalComponentHandler handler, ICraftingContext context) {
        long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
        if (!this.test(handler, context)) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinerymekanism.requirements.chemical.error.output", (Object[])new Object[]{amount, Component.translatable((String)this.chemical.getTranslationKey())}));
        }
        handler.addToOutputs(this.tank, this.chemical, amount);
        return CraftingResult.success();
    }

    public List<IJEIIngredientWrapper<ChemicalStack>> getJEIIngredientWrappers(IMachineRecipe recipe, RecipeRequirement<?, ?> requirement) {
        return Collections.singletonList(new ChemicalIngredientWrapper(this.mode, this.chemical, this.amount, requirement.chance(), false, this.tank));
    }
}

