/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.guielement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import fr.frinn.custommachinerymekanism.CustomMachineryMekanism;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.component.HeatMachineComponent;

public class HeatGuiElement
extends AbstractTexturedGuiElement
implements IComponentGuiElement<HeatMachineComponent> {
    public static final TextureInfo BASE_TEXTURE = new TextureInfo(ICustomMachineryAPI.INSTANCE.rl("textures/gui/base_fluid_storage.png"));
    public static final TextureInfo BASE_TEXTURE_FILLED = new TextureInfo(CustomMachineryMekanism.rl("textures/gui/base_heat_storage_filled.png"));
    public static final NamedCodec<HeatGuiElement> CODEC = NamedCodec.record(instance -> instance.group((App)HeatGuiElement.makePropertiesCodec().forGetter(AbstractGuiElement::getProperties), (App)TextureInfo.CODEC.optionalFieldOf("texture_empty", (Object)BASE_TEXTURE).forGetter(HeatGuiElement::getEmptyTexture), (App)TextureInfo.CODEC.optionalFieldOf("texture_filled", (Object)BASE_TEXTURE_FILLED).forGetter(HeatGuiElement::getFilledTexture), (App)NamedCodec.enumCodec(ProgressBarGuiElement.Orientation.class).optionalFieldOf("orientation", (Object)ProgressBarGuiElement.Orientation.TOP).aliases(new String[]{"direction"}).forGetter(HeatGuiElement::getOrientation), (App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf("min", (Object)300.0).forGetter(HeatGuiElement::getMin), (App)NamedCodec.doubleRange((double)1.0, (double)Double.MAX_VALUE).optionalFieldOf("max", (Object)400.0).forGetter(HeatGuiElement::getMax), (App)NamedCodec.BOOL.optionalFieldOf("highlight", (Object)true).forGetter(HeatGuiElement::highlight)).apply((Applicative)instance, HeatGuiElement::new), (String)"Heat gui element");
    private final TextureInfo emptyTexture;
    private final TextureInfo filledTexture;
    private final ProgressBarGuiElement.Orientation orientation;
    private final double min;
    private final double max;
    private final boolean highlight;

    public HeatGuiElement(AbstractGuiElement.Properties properties, TextureInfo emptyTexture, TextureInfo filledTexture, ProgressBarGuiElement.Orientation orientation, double min, double max, boolean highlight) {
        super(properties, emptyTexture);
        this.emptyTexture = emptyTexture;
        this.filledTexture = filledTexture;
        this.orientation = orientation;
        this.min = min;
        this.max = max;
        this.highlight = highlight;
    }

    public TextureInfo getEmptyTexture() {
        return this.emptyTexture;
    }

    public TextureInfo getFilledTexture() {
        return this.filledTexture;
    }

    public ProgressBarGuiElement.Orientation getOrientation() {
        return this.orientation;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean highlight() {
        return this.highlight;
    }

    public GuiElementType<HeatGuiElement> getType() {
        return Registration.HEAT_GUI_ELEMENT.get();
    }

    public MachineComponentType<HeatMachineComponent> getComponentType() {
        return Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public String getComponentId() {
        return "Heat";
    }
}

