/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.render.element;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.guielement.ChemicalGuiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public class ChemicalGuiElementWidget
extends TexturedGuiElementWidget<ChemicalGuiElement> {
    public ChemicalGuiElementWidget(ChemicalGuiElement element, IMachineScreen screen) {
        super((AbstractTexturedGuiElement)element, screen, (Component)Component.translatable((String)"custommachinery.machine.guielement.chemical"));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        this.getScreen().getTile().getComponentManager().getComponentHandler(Registration.CHEMICAL_MACHINE_COMPONENT.get()).flatMap(gasHandler -> gasHandler.getComponentForID(((ChemicalGuiElement)this.getElement()).getComponentId())).ifPresent(component -> {
            ChemicalStack stack = component.getStack();
            if (!stack.isEmpty()) {
                RenderSystem.enableBlend();
                int desiredHeight = MathUtils.clampToInt((double)((double)(this.height - 2) * (double)stack.getAmount() / (double)component.getCapacity()));
                desiredHeight = Math.clamp((long)desiredHeight, 1, this.height);
                int desiredWidth = MathUtils.clampToInt((double)((double)(this.width - 2) * (double)stack.getAmount() / (double)component.getCapacity()));
                desiredWidth = Math.clamp((long)desiredWidth, 1, this.width);
                Chemical chemical = stack.getChemical();
                MekanismRenderer.color((GuiGraphics)graphics, (ChemicalStack)stack);
                switch (((ChemicalGuiElement)this.getElement()).getOrientation()) {
                    case TOP: {
                        GuiUtils.drawTiledSprite((GuiGraphics)graphics, (int)(this.getX() + 1), (int)(this.getY() + 1), (int)(this.height - 2), (int)(this.width - 2), (int)desiredHeight, (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon()), (int)16, (int)16, (int)100, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.UP_RIGHT, (boolean)false);
                        break;
                    }
                    case BOTTOM: {
                        GuiUtils.drawTiledSprite((GuiGraphics)graphics, (int)(this.getX() + 1), (int)(this.getY() + 1), (int)desiredHeight, (int)(this.width - 2), (int)desiredHeight, (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon()), (int)16, (int)16, (int)100, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.DOWN_RIGHT, (boolean)false);
                        break;
                    }
                    case LEFT: {
                        GuiUtils.drawTiledSprite((GuiGraphics)graphics, (int)(this.getX() + 1 + this.width - 2 - desiredWidth), (int)(this.getY() + 1), (int)(this.height - 2), (int)desiredWidth, (int)(this.height - 2), (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon()), (int)16, (int)16, (int)100, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.UP_LEFT, (boolean)false);
                        break;
                    }
                    case RIGHT: {
                        GuiUtils.drawTiledSprite((GuiGraphics)graphics, (int)(this.getX() + 1), (int)(this.getY() + 1), (int)(this.height - 2), (int)desiredWidth, (int)(this.height - 2), (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon()), (int)16, (int)16, (int)100, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.UP_RIGHT, (boolean)false);
                    }
                }
                MekanismRenderer.resetColor((GuiGraphics)graphics);
                RenderSystem.disableBlend();
            }
        });
        if (this.isHovered() && ((ChemicalGuiElement)this.getElement()).highlight()) {
            ClientHandler.renderSlotHighlight((GuiGraphics)graphics, (int)(this.getX() + 1), (int)(this.getY() + 1), (int)(this.width - 2), (int)(this.height - 2));
        }
    }

    public List<Component> getTooltips() {
        return this.getScreen().getTile().getComponentManager().getComponentHandler(Registration.CHEMICAL_MACHINE_COMPONENT.get()).flatMap(gasHandler -> gasHandler.getComponentForID(((ChemicalGuiElement)this.getElement()).getComponentId())).map(component -> {
            ChemicalStack stack = component.getStack();
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(TextComponentUtil.build((Object[])new Object[]{stack}));
            tooltips.add(MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, new Object[]{TextUtils.format((long)stack.getAmount())}));
            stack.appendHoverText(Item.TooltipContext.EMPTY, tooltips, (TooltipFlag)TooltipFlag.NORMAL);
            return tooltips;
        }).orElse(Collections.emptyList());
    }
}

