/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.sound;

import fr.frinn.custommachinery.common.util.sound.AmbientSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    private static final SoundInstance DEFAULT = SimpleSoundInstance.forMusic((SoundEvent)AmbientSound.DEFAULT.sound());
    private final BlockPos pos;
    private SoundInstance sound = DEFAULT;

    public SoundManager(BlockPos pos) {
        this.pos = pos;
    }

    public boolean isCurrentlyPlaying(AmbientSound sound) {
        return this.sound != DEFAULT && this.sound.getSound() != null && this.sound.getLocation().equals((Object)sound.sound().getLocation()) && this.sound.getVolume() == sound.volume() && this.sound.getPitch() == sound.pitch() && this.sound.getSource() == sound.source() && this.sound.isLooping() == sound.loop() && this.sound.getAttenuation() == (sound.attenuation() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE) && this.sound.getDelay() == sound.delay() && this.sound.isRelative() == sound.relative();
    }

    public void setSound(@Nullable AmbientSound sound) {
        this.stop();
        if (sound == null) {
            this.sound = DEFAULT;
            return;
        }
        this.sound = new SimpleSoundInstance(sound.sound().getLocation(), sound.source(), sound.volume(), sound.pitch(), RandomSource.create(), sound.loop(), sound.delay(), sound.attenuation() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), sound.relative());
        this.play();
    }

    public boolean isPlaying() {
        return this.sound != DEFAULT && Minecraft.getInstance().getSoundManager().isActive(this.sound);
    }

    public void play() {
        if (this.sound != DEFAULT) {
            Minecraft.getInstance().getSoundManager().play(this.sound);
        }
    }

    public void stop() {
        if (this.sound != DEFAULT) {
            Minecraft.getInstance().getSoundManager().stop(this.sound);
        }
    }
}

