/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.network.SUpdateUpgradesPacket;
import fr.frinn.custommachinery.common.upgrade.UpgradeLocation;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CRemoveUpgradePacket(ResourceLocation id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CRemoveUpgradePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("remove_upgrade"));
    public static final StreamCodec<FriendlyByteBuf, CRemoveUpgradePacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CRemoveUpgradePacket::id, CRemoveUpgradePacket::new);

    public CustomPacketPayload.Type<CRemoveUpgradePacket> type() {
        return TYPE;
    }

    public static void handle(CRemoveUpgradePacket packet, IPayloadContext context) {
        UpgradeLocation location;
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer() != null && Utils.canPlayerManageMachines((Player)player) && (location = (UpgradeLocation)CustomMachinery.UPGRADES.getAllUpgrades().keySet().stream().filter(loc -> loc.id().equals((Object)packet.id)).findFirst().orElse(null)) != null) {
            context.enqueueWork(() -> {
                CustomMachinery.LOGGER.info("Player: {} removed upgrade: {}", (Object)player.getName().getString(), (Object)packet.id);
                if (FileUtils.deleteUpgradeJson(player.server, location)) {
                    CustomMachinery.UPGRADES.removeUpgrade(packet.id);
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SUpdateUpgradesPacket(CustomMachinery.UPGRADES.getAllUpgrades()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }
}

