/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.jade;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public class CustomMachineComponentProvider
implements IBlockComponentProvider {
    public static final CustomMachineComponentProvider INSTANCE = new CustomMachineComponentProvider();
    public static final ResourceLocation ID = CustomMachinery.rl("machine_component_provider");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof CustomMachineTile) {
            MutableComponent ownerName;
            CustomMachineTile tile = (CustomMachineTile)blockEntity;
            CompoundTag nbt = accessor.getServerData().getCompound("custommachinery");
            if (nbt.isEmpty() || tile.getLevel() == null) {
                return;
            }
            if (nbt.contains("owner", 8) && (ownerName = Component.Serializer.fromJson((String)nbt.getString("owner"), (HolderLookup.Provider)tile.getLevel().registryAccess())) != null && !ownerName.getString().isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"custommachinery.machine.info.owner", (Object[])new Object[]{ownerName}));
            }
            if (nbt.contains("status", 1)) {
                MachineStatus machineStatus = MachineStatus.values()[nbt.getByte("status")];
                MutableComponent status = machineStatus.getTranslatedName();
                switch (machineStatus) {
                    case ERRORED: {
                        status.withStyle(ChatFormatting.RED);
                        break;
                    }
                    case RUNNING: {
                        status.withStyle(ChatFormatting.GREEN);
                        break;
                    }
                    case PAUSED: {
                        status.withStyle(ChatFormatting.GOLD);
                    }
                }
                tooltip.add((Component)status);
            }
            if (nbt.contains("cores", 9)) {
                ListTag cores = nbt.getList("cores", 10);
                cores.forEach(tag -> {
                    if (!(tag instanceof CompoundTag)) {
                        return;
                    }
                    CompoundTag coreNbt = (CompoundTag)tag;
                    if (coreNbt.contains("recipeProgressTime", 6) && coreNbt.contains("recipeTotalTime", 3)) {
                        double recipeProgressTime = coreNbt.getDouble("recipeProgressTime");
                        int recipeTotalTime = coreNbt.getInt("recipeTotalTime");
                        float progress = (float)(recipeProgressTime / (double)recipeTotalTime);
                        MutableComponent component = Component.literal((String)((int)recipeProgressTime + " / " + recipeTotalTime)).withStyle(ChatFormatting.WHITE);
                        IElementHelper helper = IElementHelper.get();
                        tooltip.add(helper.progress(progress, (Component)component, helper.progressStyle(), BoxStyle.getNestedBox(), true));
                    }
                    if (coreNbt.contains("errorMessage", 8) && tile.getLevel() != null) {
                        tooltip.add((Component)Component.Serializer.fromJson((String)coreNbt.getString("errorMessage"), (HolderLookup.Provider)tile.getLevel().registryAccess()));
                    }
                });
            }
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

