/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.function;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import fr.frinn.custommachinery.common.component.ChunkloadMachineComponent;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.TaskDelayer;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.Machine")
public class MachineCT {
    private final CustomMachineTile internal;
    private final MapData data;

    protected MachineCT(CustomMachineTile internal) {
        this.internal = internal;
        this.data = new MapData(this.internal.getComponentManager().getComponent(Registration.DATA_MACHINE_COMPONENT.get()).orElseThrow().getData());
    }

    @ZenCodeType.Getter(value="id")
    @ZenCodeType.Method
    public String getId() {
        return this.internal.getId().toString();
    }

    @ZenCodeType.Setter(value="id")
    @ZenCodeType.Method
    public void setId(String id) {
        ResourceLocation loc = ResourceLocation.tryParse((String)id);
        if (loc == null) {
            throw new IllegalArgumentException("Invalid machine ID: " + id);
        }
        TaskDelayer.enqueue(0, () -> {
            this.internal.resetProcess();
            this.internal.refreshMachine(loc);
        });
    }

    @ZenCodeType.Getter(value="data")
    @ZenCodeType.Method
    public MapData getData() {
        return this.data;
    }

    @ZenCodeType.Getter(value="paused")
    @ZenCodeType.Method
    public boolean getPaused() {
        return this.internal.isPaused();
    }

    @ZenCodeType.Setter(value="paused")
    @ZenCodeType.Method
    public void setPaused(boolean paused) {
        this.internal.setPaused(paused);
    }

    @ZenCodeType.Getter(value="ownerName")
    @ZenCodeType.Method
    @Nullable
    public Component getOwnerName() {
        return this.internal.getOwnerName();
    }

    @ZenCodeType.Getter(value="ownerId")
    @ZenCodeType.Method
    @Nullable
    public UUID getOwnerId() {
        return this.internal.getOwnerId();
    }

    @ZenCodeType.Method
    public boolean isOwner(LivingEntity entity) {
        return this.internal.isOwner(entity);
    }

    @ZenCodeType.Getter(value="owner")
    @ZenCodeType.Method
    @Nullable
    public LivingEntity getOwner() {
        return this.internal.getOwner();
    }

    @ZenCodeType.Setter(value="owner")
    @ZenCodeType.Method
    public void setOwner(LivingEntity entity) {
        this.internal.setOwner(entity);
    }

    @ZenCodeType.Getter(value="energyStored")
    @ZenCodeType.Method
    public long getEnergyStored() {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(EnergyMachineComponent::getEnergy).orElse(0L);
    }

    @ZenCodeType.Setter
    @ZenCodeType.Method
    public void setEnergyStored(long energy) {
        this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).ifPresent(component -> component.setEnergy(energy));
    }

    @ZenCodeType.Getter(value="energyCapacity")
    @ZenCodeType.Method
    public long getEnergyCapacity() {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(EnergyMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public int addEnergy(int toAdd, boolean simulate) {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(component -> component.receiveRecipeEnergy(toAdd, simulate)).orElse(0);
    }

    @ZenCodeType.Method
    public int removeEnergy(int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(component -> component.extractRecipeEnergy(toRemove, simulate)).orElse(0);
    }

    @ZenCodeType.Method
    public FluidStack getFluidStored(String tank) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getFluid).orElse(FluidStack.EMPTY);
    }

    @ZenCodeType.Method
    public void setFluidStored(String tank, IFluidStack stack) {
        this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(x -> x.setFluidStack((FluidStack)stack.getImmutableInternal()));
    }

    @ZenCodeType.Method
    public int getFluidCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getCapacity).orElse(0);
    }

    @ZenCodeType.Method
    public int addFluid(IFluidStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.fill((FluidStack)stack.getInternal(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).orElse(0);
    }

    @ZenCodeType.Method
    public int addFluidToTank(String tank, IFluidStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.fillBypassLimit((FluidStack)stack.getInternal(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).orElse(0);
    }

    @ZenCodeType.Method
    public IFluidStack removeFluid(IFluidStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).map(handler -> (FluidComponentHandler)handler).map(handler -> IFluidStack.of((Object)handler.drain((FluidStack)stack.getInternal(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE))).orElse(IFluidStack.empty());
    }

    @ZenCodeType.Method
    public IFluidStack removeFluidFromTank(String tank, int amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> IFluidStack.of((Object)component.drainBypassLimit(amount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE))).orElse(IFluidStack.empty());
    }

    @ZenCodeType.Method
    public IItemStack getItemStored(String slot) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> IItemStack.of((ItemStack)component.getItemStack())).orElse(IItemStack.empty());
    }

    @ZenCodeType.Method
    public void setItemStored(String slot, IItemStack stackCT) {
        this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setItemStack(stackCT.getInternal()));
    }

    @ZenCodeType.Method
    public int getItemCapacity(String slot) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::getCapacity).orElse(0);
    }

    @ZenCodeType.Method
    public IItemStack addItemToSlot(String slot, IItemStack stackCT, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> IItemStack.of((ItemStack)component.insertItemBypassLimit(stackCT.getInternal(), simulate))).orElse(stackCT);
    }

    @ZenCodeType.Method
    public IItemStack removeItemFromSlot(String slot, int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> IItemStack.of((ItemStack)component.extractItemBypassLimit(toRemove, simulate))).orElse(IItemStack.empty());
    }

    @ZenCodeType.Method
    public void lockSlot(String slot) {
        this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setLocked(true));
    }

    @ZenCodeType.Method
    public void unlockSlot(String slot) {
        this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setLocked(false));
    }

    @ZenCodeType.Method
    public boolean isSlotLocked(String slot) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::isLocked).orElseThrow(() -> new IllegalArgumentException("Invalid slot id: " + slot));
    }

    @ZenCodeType.Method
    public void enableChunkload(int radius) {
        this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).ifPresent(component -> component.setActive(radius));
    }

    @ZenCodeType.Method
    public void disableChunkload() {
        this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).ifPresent(component -> component.setInactive((ServerLevel)this.internal.getLevel()));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="chunkloadEnabled")
    public boolean isChunkloadEnabled() {
        return this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).map(ChunkloadMachineComponent::isActive).orElse(false);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="chunkloadRadius")
    public int getChunkloadRadius() {
        return this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).map(ChunkloadMachineComponent::getRadius).orElse(0);
    }
}

