/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class GridListWidget<E extends Entry>
extends AbstractWidget {
    private final List<E> list = new ArrayList();
    private int maxColumns;
    private double scrollAmount;
    private boolean scrolling = false;
    @Nullable
    private E selected;
    private boolean renderSelection = false;

    public GridListWidget(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.maxColumns = width / 20;
    }

    public void clear() {
        this.list.clear();
    }

    public void addEntry(E entry) {
        this.list.add(entry);
    }

    public void addEntry(int index, E entry) {
        this.list.add(index, entry);
    }

    public List<E> getAll() {
        return Collections.unmodifiableList(this.list);
    }

    public boolean remove(E entry) {
        return this.list.remove(entry);
    }

    public void setRenderSelection() {
        this.renderSelection = true;
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    @Nullable
    public E getElementUnderMouse(double mouseX, double mouseY) {
        if (mouseX < (double)this.getX() || mouseX > (double)(this.getX() + this.maxColumns * 20) || mouseY < (double)this.getY() || mouseY > (double)(this.getY() + this.getHeight())) {
            return null;
        }
        int index = (int)((mouseY - (double)this.getY() + this.scrollAmount) / 20.0) * this.maxColumns + (int)((mouseX - (double)this.getX()) / 20.0);
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return (E)((Entry)this.list.get(index));
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.getScrollAmount() + (double)scroll);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double scroll) {
        this.scrollAmount = Mth.clamp((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getHeight() - 4);
    }

    protected int getMaxPosition() {
        return this.list.size() / this.maxColumns * 20;
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.getHeight();
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int i;
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        for (i = 0; i < this.list.size(); ++i) {
            int x = i % this.maxColumns * 20;
            int y = i / this.maxColumns * 20 - (int)this.getScrollAmount();
            graphics.pose().pushPose();
            graphics.pose().translate((float)x, (float)y, 0.0f);
            Entry entry = (Entry)this.list.get(i);
            if (this.renderSelection && this.selected == entry) {
                graphics.fill(0, 0, 20, 20, FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0));
            }
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            entry.render(graphics, mouseX, mouseY, partialTick);
            graphics.pose().popPose();
        }
        graphics.pose().popPose();
        if (this.getMaxScroll() > 0) {
            i = this.getX() + this.getWidth() - 10;
            int j = i + 6;
            int n = this.getHeight() * this.getHeight() / this.getMaxPosition();
            n = Mth.clamp((int)n, (int)32, (int)(this.getHeight() - 8));
            int o = (int)this.getScrollAmount() * (this.getHeight() - n) / this.getMaxScroll() + this.getY();
            if (o < this.getY()) {
                o = this.getY();
            }
            graphics.fill(i, this.getY(), j, this.getY() + this.getHeight(), -16777216);
            graphics.fill(i, o, j, o + n, -8355712);
            graphics.fill(i, o, j - 1, o + n - 1, -4144960);
        }
        graphics.disableScissor();
        E hovered = this.getElementUnderMouse(mouseX, mouseY);
        if (hovered != null) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.addAll(((Entry)hovered).getTooltips());
            graphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        E selected = this.getElementUnderMouse(mouseX, mouseY);
        if (selected != null) {
            this.selected = selected;
            return selected.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button != 0 || !this.scrolling) {
            return false;
        }
        if (mouseY < (double)this.getY()) {
            this.setScrollAmount(0.0);
        } else if (mouseY > (double)(this.getY() + this.getHeight())) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double d = Math.max(1, this.getMaxScroll());
            int i = this.getHeight();
            int j = Mth.clamp((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
            double e = Math.max(1.0, d / (double)(i - j));
            this.setScrollAmount(this.getScrollAmount() + dragY * e);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollAmount(this.getScrollAmount() - scrollY * 10.0);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public static abstract class Entry
    implements ContainerEventHandler {
        @Nullable
        private GuiEventListener focused;
        private boolean dragging;

        public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

        public abstract List<Component> getTooltips();

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.getFocused() != null && this.getFocused().mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean isDragging() {
            return this.dragging;
        }

        public void setDragging(boolean isDragging) {
            this.dragging = isDragging;
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            if (focused != null) {
                focused.setFocused(true);
            }
            this.focused = focused;
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent event, int index) {
            if (this.children().isEmpty()) {
                return null;
            }
            ComponentPath componentPath = ((GuiEventListener)this.children().get(Math.min(index, this.children().size() - 1))).nextFocusPath(event);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)componentPath);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            int n;
            if (!(event instanceof FocusNavigationEvent.ArrowNavigation)) return super.nextFocusPath(event);
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
            try {
                ScreenDirection screenDirection;
                ScreenDirection direction = screenDirection = arrowNavigation.direction();
                if (direction != ScreenDirection.RIGHT) return null;
                n = 1;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int i = n;
            if (i == 0) {
                return null;
            }
            int k = Mth.clamp((int)(i + this.children().indexOf(this.getFocused())), (int)0, (int)(this.children().size() - 1));
            while (k >= 0) {
                if (k >= this.children().size()) return super.nextFocusPath(event);
                GuiEventListener guiEventListener = (GuiEventListener)this.children().get(k);
                ComponentPath componentPath = guiEventListener.nextFocusPath(event);
                if (componentPath != null) return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)componentPath);
                k += i;
            }
            return super.nextFocusPath(event);
        }
    }
}

