/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.guielement.FuelGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class FuelGuiElementWidget
extends AbstractGuiElementWidget<FuelGuiElement> {
    public FuelGuiElementWidget(FuelGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.literal((String)"Fuel"));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        double percent = this.getScreen().getTile().getComponentManager().getComponent(Registration.FUEL_MACHINE_COMPONENT.get()).map(component -> component.getMaxFuel() == 0 ? 0.0 : (double)component.getFuel() / (double)component.getMaxFuel()).orElse(0.0);
        if (percent == 0.0 && this.getScreen().getMachine().isDummy()) {
            percent = 1.0 - (double)(System.currentTimeMillis() % 2000L) / 2000.0;
        }
        ClientHandler.renderOrientedProgressTextures(graphics, ((FuelGuiElement)this.getElement()).getEmptyTexture(), ((FuelGuiElement)this.getElement()).getFilledTexture(), this.getX(), this.getY(), this.width, this.height, percent, ((FuelGuiElement)this.getElement()).getOrientation());
    }

    @Override
    public List<Component> getTooltips() {
        if (!((FuelGuiElement)this.getElement()).getTooltips().isEmpty()) {
            return ((FuelGuiElement)this.getElement()).getTooltips();
        }
        return this.getScreen().getTile().getComponentManager().getComponent(Registration.FUEL_MACHINE_COMPONENT.get()).map(component -> Collections.singletonList(Component.translatable((String)"custommachinery.gui.element.fuel.tooltip", (Object[])new Object[]{component.getFuel()}))).orElse(Collections.emptyList());
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return false;
    }
}

