/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.block_entities.AbstractAcceleratorEntity;
import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.block_entities.ExperienceReceivingEntity;
import com.cyanogen.cognition.block_entities.bibliophage.bookshelves.AbstractInfectedBookshelfEntity;
import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.utils.ItemUtils;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AttunementStaffItem
extends Item {
    public AttunementStaffItem(Item.Properties p) {
        super(p);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && stack.is((Item)RegisterItems.ATTUNEMENT_STAFF.get()) && ItemUtils.getCustomDataTag(stack).contains("Type")) {
            this.reset(stack);
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.unbind_obelisk"), true);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity entity = level.getBlockEntity(pos);
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            if (entity instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)entity;
                this.handleObelisk(obelisk, stack, player);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (entity instanceof ExperienceReceivingEntity) {
                ExperienceReceivingEntity receiver = (ExperienceReceivingEntity)entity;
                this.handleExperienceReceivingBlock(receiver, stack, player, level);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (entity instanceof AbstractAcceleratorEntity) {
                AbstractAcceleratorEntity accelerator = (AbstractAcceleratorEntity)entity;
                this.handleAccelerator(accelerator, player);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (entity instanceof AbstractInfectedBookshelfEntity) {
                AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)entity;
                this.handleBookshelf(bookshelf, player);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useOn(context);
    }

    public void handleObelisk(ExperienceObeliskEntity obelisk, ItemStack stack, Player player) {
        BlockPos thisPos = obelisk.getBlockPos();
        CompoundTag tag = ItemUtils.getCustomDataTag(stack);
        tag.putInt("BoundX", thisPos.getX());
        tag.putInt("BoundY", thisPos.getY());
        tag.putInt("BoundZ", thisPos.getZ());
        tag.putString("Type", "Obelisk");
        ItemUtils.saveCustomDataTag(stack, tag);
        player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.bind_obelisk"), true);
    }

    public void handleExperienceReceivingBlock(ExperienceReceivingEntity receiver, ItemStack stack, Player player, Level level) {
        double range = (Double)Config.COMMON.bindingRange.get();
        BlockPos thisPos = receiver.getBlockPos();
        CompoundTag tag = ItemUtils.getCustomDataTag(stack);
        if (tag.getString("Type").equals("Obelisk")) {
            BlockPos savedPos = new BlockPos(tag.getInt("BoundX"), tag.getInt("BoundY"), tag.getInt("BoundZ"));
            BlockEntity savedEntity = level.getBlockEntity(savedPos);
            if (receiver.isBound() && savedPos.equals((Object)receiver.getBoundPos())) {
                receiver.clearBoundPos();
                player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.unbind_target"), true);
            } else if (MiscUtils.straightLineDistance(thisPos, savedPos) <= range) {
                if (savedEntity instanceof ExperienceObeliskEntity) {
                    receiver.setBoundPos(savedPos);
                    player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.bind_target", (Object[])new Object[]{Component.literal((String)savedPos.toShortString()).withStyle(ChatFormatting.GREEN)}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.obelisk_doesnt_exist", (Object[])new Object[]{Component.literal((String)savedPos.toShortString())}).withStyle(ChatFormatting.RED), true);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.obelisk_too_far"), true);
            }
        } else if (receiver.isBound()) {
            receiver.clearBoundPos();
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.unbind_target"), true);
        }
    }

    public void handleAccelerator(AbstractAcceleratorEntity accelerator, Player player) {
        accelerator.toggleRedstoneEnabled();
        if (accelerator.redstoneEnabled) {
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.enable_redstone"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.disable_redstone"), true);
        }
    }

    public void handleBookshelf(AbstractInfectedBookshelfEntity bookshelf, Player player) {
        boolean status = bookshelf.toggleActivity();
        if (status) {
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.enable_redstone"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.disable_redstone"), true);
        }
    }

    public void reset(ItemStack stack) {
        CompoundTag tag = ItemUtils.getCustomDataTag(stack);
        tag.remove("Type");
        tag.remove("BoundX");
        tag.remove("BoundY");
        tag.remove("BoundZ");
        ItemUtils.saveCustomDataTag(stack, tag);
    }
}

