/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.neoforge.client;

import it.hurts.shatterbyte.clavis.common.ClavisClient;
import it.hurts.shatterbyte.clavis.common.client.render.LockWorldRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ChunkEvents {
    @SubscribeEvent
    public static void onLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            chunkAccess = event.getLevel();
            if (chunkAccess instanceof ClientLevel) {
                ClientLevel level = (ClientLevel)chunkAccess;
                ClavisClient.onLoadChunk(level, chunk);
            }
        }
    }

    @SubscribeEvent
    public static void onUnload(ChunkEvent.Unload event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            chunkAccess = event.getLevel();
            if (chunkAccess instanceof ClientLevel) {
                ClientLevel level = (ClientLevel)chunkAccess;
                ClavisClient.onUnloadChunk(level, chunk);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTravel(EntityTravelToDimensionEvent event) {
        LockWorldRenderer.clear();
    }
}

