/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.data.MinigameStyleData;
import it.hurts.shatterbyte.clavis.common.data.TooltipInfoData;
import it.hurts.shatterbyte.clavis.common.minigame.Minigame;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MinigameInfoWidget
extends AbstractWidget {
    public static final ResourceLocation EASY = Clavis.path("textures/icon/easy.png");
    public static final ResourceLocation MEDIUM = Clavis.path("textures/icon/medium.png");
    public static final ResourceLocation HARD = Clavis.path("textures/icon/hard.png");
    public static final ResourceLocation TIME = Clavis.path("textures/icon/time.png");
    public static final ResourceLocation QUALITY = Clavis.path("textures/icon/quality.png");
    public final ResourceLocation STAT_BG;
    TooltipInfoData difficultyInfo;
    TooltipInfoData timeInfo;
    TooltipInfoData qualityInfo;
    Minigame<?> game;
    MinigameStyleData styleData;

    public MinigameInfoWidget(Minigame<?> game, MinigameStyleData styleData) {
        super(0, 0, 160, 16, (Component)Component.empty());
        this.game = game;
        this.styleData = styleData;
        this.STAT_BG = Clavis.path(game.getMinigameType().getNamespace(), "textures/lockpicking/" + game.getMinigameType().getPath() + "/stat_background.png");
        Font font = Minecraft.getInstance().font;
        this.difficultyInfo = new TooltipInfoData(font, "difficulty", Math.round(170.66667f));
        this.timeInfo = new TooltipInfoData(font, "time", Math.round(170.66667f));
        this.qualityInfo = new TooltipInfoData(font, "quality", Math.round(170.66667f));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float difficulty = this.game.getDifficulty();
        long tickCount = this.game.getTickCount();
        float lootQuality = this.game.getLootQuality();
        float mouseHovered = Math.clamp((float)(mouseX - this.getX()) / (float)this.getWidth(), 0.0f, 1.0f);
        boolean difficultyHovered = this.isHovered() && mouseHovered < 0.33f;
        boolean timeHovered = this.isHovered() && mouseHovered >= 0.33f && mouseHovered < 0.66f;
        boolean qualityHovered = this.isHovered() && mouseHovered >= 0.66f;
        Font font = Minecraft.getInstance().font;
        LocalTime time = LocalTime.ofSecondOfDay(Mth.floor((float)((float)tickCount / 20.0f)));
        String timeString = time.format(DateTimeFormatter.ISO_LOCAL_TIME);
        if (timeString.startsWith("00:")) {
            timeString = timeString.substring(3);
        }
        ResourceLocation difficultyIcon = difficulty < 0.33f ? EASY : (difficulty < 0.66f ? MEDIUM : HARD);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 1.0f);
        this.renderStat(guiGraphics, difficultyHovered, Math.round(difficulty * 100.0f) + "%", font, difficultyIcon);
        guiGraphics.pose().translate(54.0f, 0.0f, 0.0f);
        this.renderStat(guiGraphics, timeHovered, timeString, font, TIME);
        guiGraphics.pose().translate(54.0f, 0.0f, 0.0f);
        this.renderStat(guiGraphics, qualityHovered, Math.round(lootQuality * 100.0f) + "%", font, QUALITY);
        guiGraphics.pose().popPose();
        boolean isDescription = LockpickingScreen.hasShiftDown();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 20.0f);
        if (qualityHovered) {
            LockpickingScreen.renderTooltip(this.game.getMinigameType(), font, this.qualityInfo, guiGraphics, mouseX, mouseY, partialTick, isDescription);
        } else if (timeHovered) {
            LockpickingScreen.renderTooltip(this.game.getMinigameType(), font, this.timeInfo, guiGraphics, mouseX, mouseY, partialTick, isDescription);
        } else if (difficultyHovered) {
            LockpickingScreen.renderTooltip(this.game.getMinigameType(), font, this.difficultyInfo, guiGraphics, mouseX, mouseY, partialTick, isDescription);
        }
        guiGraphics.pose().popPose();
    }

    private void renderStat(GuiGraphics guiGraphics, boolean isHovered, String string, Font font, ResourceLocation icon) {
        if (isHovered) {
            guiGraphics.fill(0, 0, 52, 16, 0, this.styleData.getTitleColor());
            guiGraphics.fill(-1, 0, 53, 16, 0, this.styleData.getTitleColor());
            guiGraphics.fill(0, -1, 52, 17, 0, this.styleData.getTitleColor());
        }
        guiGraphics.blit(this.STAT_BG, 0, 0, 52, 16, 0.0f, 0.0f, 52, 16, 52, 16);
        RenderSystem.enableBlend();
        guiGraphics.blit(icon, 2, 2, 12, 13, 0.0f, 0.0f, 12, 13, 12, 13);
        RenderSystem.disableBlend();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(18.0, 5.5, 0.0);
        guiGraphics.pose().scale(0.75f, 0.75f, 1.0f);
        guiGraphics.drawString(font, (Component)Component.literal((String)string).withStyle(ChatFormatting.BOLD), 0, 0, this.styleData.getTitleColor(), false);
        guiGraphics.pose().popPose();
    }

    public void playDownSound(SoundManager handler) {
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

