/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.worldgen;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.util.RewardsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

public class CCSurfaceFeature
extends Feature<NoneFeatureConfiguration> {
    public CCSurfaceFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        boolean canPlace;
        int z;
        int y;
        int x;
        if (!((Boolean)CCubesSettings.surfaceGeneration.get()).booleanValue()) {
            return false;
        }
        if (RewardsUtil.rand.nextInt((Integer)CCubesSettings.surfaceGenAmount.get()) != 0) {
            return false;
        }
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        BlockState bs = level.getBlockState(pos = new BlockPos(x = pos.getX() + RewardsUtil.rand.nextInt(16), y = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, new BlockPos(x, 0, z = pos.getZ() + RewardsUtil.rand.nextInt(16))).getY() - 1, z));
        if (bs.is(Blocks.WATER)) {
            return false;
        }
        boolean bl = canPlace = !bs.canBeReplaced();
        if (!canPlace) {
            pos = pos.above();
            if (!bs.canBeReplaced() || bs.is(Blocks.WATER)) {
                return false;
            }
        }
        level.setBlock(pos, ((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState(), 3);
        return true;
    }
}

