/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.tileentities.TileGiantCube;
import chanceCubes.util.RewardsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GiantCubeUtil {
    public static boolean checkMultiBlockForm(BlockPos pos, Level level, boolean build) {
        if (((Boolean)CCubesSettings.disableGiantCC.get()).booleanValue()) {
            return false;
        }
        BlockPos bottomLeft = GiantCubeUtil.findBottomCorner(pos, level);
        int cx = bottomLeft.getX();
        int cy = bottomLeft.getY();
        int cz = bottomLeft.getZ();
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int y = cy; y < cy + 3; ++y) {
                for (int z = cz; z < cz + 3; ++z) {
                    if (!level.getBlockState(new BlockPos(x, y, z)).getBlock().equals(CCubesBlocks.CHANCE_CUBE.get())) continue;
                    ++i;
                }
            }
        }
        if (build) {
            if (i > 26) {
                GiantCubeUtil.setupStructure(new BlockPos(cx, cy, cz), level, true);
                return true;
            }
            return false;
        }
        return i > 26;
    }

    public static void setupStructure(BlockPos pos, Level level, boolean areCoordsCorrect) {
        if (((Boolean)CCubesSettings.disableGiantCC.get()).booleanValue()) {
            return;
        }
        int cx = pos.getX();
        int cy = pos.getY();
        int cz = pos.getZ();
        if (!areCoordsCorrect) {
            BlockPos bottomLeft = GiantCubeUtil.findBottomCorner(pos, level);
            cx = bottomLeft.getX();
            cy = bottomLeft.getY();
            cz = bottomLeft.getZ();
        }
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int z = cz; z < cz + 3; ++z) {
                for (int y = cy; y < cy + 3; ++y) {
                    boolean master;
                    RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.GIANT_CUBE.get())).defaultBlockState(), level, new BlockPos(x, y, z), ++i == 27 ? 3 : 2, level.getBlockState(new BlockPos(x, y, z)).getBlock().equals(CCubesBlocks.CHANCE_CUBE.get()));
                    BlockEntity tile = level.getBlockEntity(new BlockPos(x, y, z));
                    boolean bl = master = x == cx + 1 && y == cy + 1 && z == cz + 1;
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).setMasterCoords(cx + 1, cy + 1, cz + 1);
                    ((TileGiantCube)tile).setHasMaster(true);
                    ((TileGiantCube)tile).setIsMaster(master);
                }
            }
        }
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)CCubesSounds.GIANT_CUBE_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static BlockPos findBottomCorner(BlockPos pos, Level level) {
        int cx = pos.getX();
        int cy = pos.getY();
        int cz = pos.getZ();
        while (level.getBlockState(pos.offset(0, -1, 0)).getBlock().equals(CCubesBlocks.CHANCE_CUBE.get())) {
            pos = pos.offset(0, -1, 0);
            --cy;
        }
        while (level.getBlockState(pos.offset(-1, 0, 0)).getBlock().equals(CCubesBlocks.CHANCE_CUBE.get())) {
            pos = pos.offset(-1, 0, 0);
            --cx;
        }
        while (level.getBlockState(pos.offset(0, 0, -1)).getBlock().equals(CCubesBlocks.CHANCE_CUBE.get())) {
            pos = pos.offset(0, 0, -1);
            --cz;
        }
        return new BlockPos(cx, cy, cz);
    }

    public static void resetStructure(BlockPos pos, Level level) {
        for (int x = pos.getX() - 1; x < pos.getX() + 2; ++x) {
            for (int y = pos.getY() - 1; y < pos.getY() + 2; ++y) {
                for (int z = pos.getZ() - 1; z < pos.getZ() + 2; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockEntity tile = level.getBlockEntity(blockPos);
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    level.removeBlockEntity(blockPos);
                    level.setBlockAndUpdate(blockPos, ((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState());
                }
            }
        }
    }

    public static void removeStructure(BlockPos pos, Level level) {
        for (int x = pos.getX() - 1; x < pos.getX() + 2; ++x) {
            for (int y = pos.getY() - 1; y < pos.getY() + 2; ++y) {
                for (int z = pos.getZ() - 1; z < pos.getZ() + 2; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockEntity tile = level.getBlockEntity(blockPos);
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    level.removeBlockEntity(blockPos);
                    level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }
}

