/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.tileentities;

import chanceCubes.blocks.CCubesBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileChanceCube
extends BlockEntity {
    private static final Random random = new Random();
    private int chance;
    private boolean isScanned = false;

    public TileChanceCube(BlockPos pos, BlockState state) {
        this(Math.round((float)(random.nextGaussian() * 40.0)), pos, state);
    }

    public TileChanceCube(int initialChance, BlockPos pos, BlockState state) {
        super((BlockEntityType)CCubesBlocks.TILE_CHANCE_CUBE.get(), pos, state);
        while (initialChance > 100 || initialChance < -100) {
            initialChance = Math.round((float)(random.nextGaussian() * 40.0));
        }
        this.setChance(initialChance);
    }

    public void setChance(int newChance) {
        this.chance = newChance;
    }

    public int getChance() {
        return this.chance;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("chance", this.getChance());
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.chance = nbt.getInt("chance");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.loadAdditional(pkt.getTag(), registries);
    }

    public boolean isScanned() {
        return this.isScanned;
    }

    public void setScanned(boolean isScanned) {
        this.isScanned = isScanned;
    }
}

