/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SkyblockReward
extends BaseCustomReward {
    private static final Random TREE_RAND = new Random(System.currentTimeMillis());
    private static final ItemStack[] chestStuff = new ItemStack[]{new ItemStack((ItemLike)Items.STRING, 12), new ItemStack((ItemLike)Items.LAVA_BUCKET), new ItemStack((ItemLike)Items.BONE), new ItemStack((ItemLike)Items.SUGAR_CANE), new ItemStack((ItemLike)Blocks.RED_MUSHROOM), new ItemStack((ItemLike)Blocks.ICE, 2), new ItemStack((ItemLike)Items.PUMPKIN_SEEDS), new ItemStack((ItemLike)Blocks.OAK_SAPLING), new ItemStack((ItemLike)Blocks.BROWN_MUSHROOM), new ItemStack((ItemLike)Items.MELON), new ItemStack((ItemLike)Blocks.CACTUS), new ItemStack((ItemLike)Blocks.OAK_LOG, 6)};

    public SkyblockReward() {
        super("chancecubes:sky_block", 10);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        int skyblockHeight = level.getLogicalHeight() + level.dimensionType().minY() - 16;
        if (!level.dimensionType().hasSkyLight()) {
            skyblockHeight = pos.getY();
        }
        Block b = Blocks.DIRT;
        BlockPos skyblockPos = new BlockPos(pos.getX(), skyblockHeight, pos.getZ());
        for (int i = 0; i < 3; ++i) {
            if (i == 2) {
                b = Blocks.GRASS_BLOCK;
            }
            for (int c = 0; c < 3; ++c) {
                int xOffset = c == 0 ? -1 : 2;
                int zOffset = c == 2 ? 2 : -1;
                for (int xx = 0; xx < 3; ++xx) {
                    for (int zz = 0; zz < 3; ++zz) {
                        level.setBlock(skyblockPos.offset(xOffset + xx, i, zOffset + zz), b.defaultBlockState(), 3);
                        RewardsUtil.placeBlock(b.defaultBlockState(), (Level)level, skyblockPos.offset(xOffset + xx, i, zOffset + zz));
                    }
                }
            }
        }
        RewardsUtil.placeBlock(Blocks.BEDROCK.defaultBlockState(), (Level)level, skyblockPos.offset(0, 1, 0));
        player.moveTo((double)pos.getX(), (double)(skyblockHeight + 3), (double)pos.getZ());
        RewardsUtil.placeBlock((BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.WEST), (Level)level, skyblockPos.offset(-1, 3, 0));
        BlockEntity te = level.getBlockEntity(skyblockPos.offset(-1, 3, 0));
        if (!(te instanceof ChestBlockEntity)) {
            return;
        }
        ChestBlockEntity chest = (ChestBlockEntity)te;
        for (int i = 0; i < chestStuff.length; ++i) {
            int slot = (i < 4 ? 0 : (i < 8 ? 1 : 2)) * 9 + i % 4;
            chest.setItem(slot, chestStuff[i].copy());
        }
    }
}

