/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.GameTurn;
import chanceCubes.util.Point;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class Connect4Reward
extends BaseCustomReward {
    private static final int WIDTH = 7;
    private static final int HEIGHT = 6;

    public Connect4Reward() {
        super("chancecubes:connect_4", 0);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings) {
        int y;
        int z;
        int x;
        final int mistakeChance = super.getSettingAsInt(settings, "mistakeChance", 3, 0, 100);
        RewardsUtil.sendMessageToPlayer(player, "Lets play Connect 4!");
        RewardsUtil.sendMessageToPlayer(player, "Beat the Computer to get 5 Diamonds!");
        final RewardBlockCache cache = new RewardBlockCache((Level)level, pos, player.getOnPos());
        BlockPos playerPos = pos.offset(3, 0, 0);
        player.moveTo((double)playerPos.getX(), (double)playerPos.getY(), (double)playerPos.getZ(), 0.0f, 0.0f);
        player.level().addFreshEntity((Entity)new ItemEntity(player.level(), (double)playerPos.getX(), (double)playerPos.getY(), (double)playerPos.getZ(), new ItemStack((ItemLike)Blocks.RED_CONCRETE_POWDER, 21)));
        for (x = -5; x < 6; ++x) {
            for (z = -6; z < 7; ++z) {
                for (int y2 = 0; y2 < 9; ++y2) {
                    cache.cacheBlock(new BlockPos(x, y2, z), Blocks.AIR.defaultBlockState());
                }
            }
        }
        for (x = -3; x < 4; ++x) {
            for (z = -4; z < 5; ++z) {
                if (z != -4 && z != 4 && x != 0) continue;
                level.setBlockAndUpdate(pos.offset(x, 0, z), Blocks.BEDROCK.defaultBlockState());
            }
        }
        for (y = 0; y < 8; ++y) {
            for (int x2 = -1; x2 < 2; ++x2) {
                level.setBlockAndUpdate(pos.offset(x2, y, -4), Blocks.BEDROCK.defaultBlockState());
                level.setBlockAndUpdate(pos.offset(x2, y, 4), Blocks.BEDROCK.defaultBlockState());
            }
        }
        for (x = -1; x < 2; ++x) {
            for (z = -4; z < 5; ++z) {
                if (z != -4 && z != 4 && x != -1 && x != 1) continue;
                level.setBlockAndUpdate(pos.offset(x, 7, z), Blocks.BEDROCK.defaultBlockState());
            }
        }
        for (y = 1; y < 7; ++y) {
            for (z = -3; z < 4; ++z) {
                level.setBlockAndUpdate(pos.offset(-1, y, z), Blocks.GLASS.defaultBlockState());
                level.setBlockAndUpdate(pos.offset(1, y, z), Blocks.GLASS.defaultBlockState());
            }
        }
        for (y = 0; y < 8; ++y) {
            level.setBlockAndUpdate(pos.offset(0, y, -5), Blocks.LADDER.defaultBlockState());
            level.setBlockAndUpdate(pos.offset(0, y, 5), (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)Direction.SOUTH));
        }
        level.setBlockAndUpdate(pos.offset(-2, 1, -4), Blocks.BEDROCK.defaultBlockState());
        level.setBlockAndUpdate(pos.offset(2, 1, -4), Blocks.BEDROCK.defaultBlockState());
        level.setBlockAndUpdate(pos.offset(-2, 1, 4), Blocks.BEDROCK.defaultBlockState());
        level.setBlockAndUpdate(pos.offset(2, 1, 4), Blocks.BEDROCK.defaultBlockState());
        Scheduler.scheduleTask(new Task(this, "Connect_4_Game", 10000, 5){
            final Board board;
            {
                super(name, delay, updateTick);
                this.board = new Board();
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                for (int z = -3; z < 4; ++z) {
                    for (int y = 1; y < 7; ++y) {
                        BlockPos pos2;
                        if (this.board.board[(y - 1) * 7 + (z + 3)] != 0 || y - 2 >= 0 && this.board.board[(y - 2) * 7 + (z + 3)] == 0 || level.getBlockState(pos2 = pos.offset(0, y, z)).isAir() || !level.getBlockState(pos2).getBlock().equals(Blocks.RED_CONCRETE_POWDER)) continue;
                        this.makeMove(z + 3, y - 1);
                    }
                }
            }

            private void makeMove(int x, int y) {
                this.board.placeMove(x, y, GameTurn.PLAYER);
                this.board.updateWorldView((Level)level, pos);
                boolean playerWon = this.board.hasWon(x, y, GameTurn.PLAYER);
                if (!this.board.isTie() && !playerWon) {
                    this.board.minimax(0, GameTurn.CPU, null, mistakeChance);
                    this.board.placeMove(this.board.computersMove.x, this.board.computersMove.y, GameTurn.CPU);
                    level.setBlockAndUpdate(pos.offset(0, 8, this.board.computersMove.x - 3), Blocks.YELLOW_CONCRETE_POWDER.defaultBlockState());
                }
                boolean gameOver = false;
                if (playerWon) {
                    RewardsUtil.sendMessageToPlayer(player, "You Won!");
                    player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)Items.DIAMOND, 5)));
                    gameOver = true;
                } else if (this.board.hasWon(this.board.computersMove.x, this.board.computersMove.y, GameTurn.CPU)) {
                    RewardsUtil.sendMessageToPlayer(player, "The Computer won! Better luck next time!");
                    gameOver = true;
                } else if (this.board.isTie()) {
                    RewardsUtil.sendMessageToPlayer(player, "You tied! Better luck next time!");
                    gameOver = true;
                }
                if (gameOver) {
                    this.delayLeft = 0;
                    Scheduler.scheduleTask(new Task("Connect_4_Game_End_Delay", 40){

                        @Override
                        public void callback() {
                            cache.restoreBlocks((Entity)player);
                        }
                    });
                }
            }
        });
    }

    private static class Board {
        public final int[] board = new int[42];
        public Point computersMove;

        private Board() {
        }

        public boolean isTie() {
            return this.getAvailableStates().isEmpty();
        }

        public void placeMove(int x, int y, GameTurn turn) {
            this.board[7 * y + x] = turn == GameTurn.PLAYER ? 2 : 1;
        }

        private boolean hasWon(int placedX, int placedY, GameTurn playerTurn) {
            int adj;
            int adjY;
            int adjX;
            int adj2;
            int i;
            int turn = playerTurn == GameTurn.PLAYER ? 2 : 1;
            int y = placedY * 7;
            for (i = Math.max(0, placedX - 3); i <= placedX; ++i) {
                adj2 = i + y;
                if (adj2 < 0 || adj2 >= 42 || i + 3 >= 7 || this.board[adj2] != turn || this.board[adj2 + 1] != turn || this.board[adj2 + 2] != turn || this.board[adj2 + 3] != turn) continue;
                return true;
            }
            for (i = Math.max(0, placedY - 3); i <= placedY; ++i) {
                adj2 = placedX + i * 7;
                if (adj2 < 0 || adj2 >= 42 || i + 3 >= 6 || this.board[adj2] != turn || this.board[adj2 + 7] != turn || this.board[adj2 + 14] != turn || this.board[adj2 + 21] != turn) continue;
                return true;
            }
            for (i = -3; i <= 0; ++i) {
                adjX = placedX + i;
                adjY = placedY + i;
                adj = adjX + adjY * 7;
                if (adj < 0 || adj >= 42 || adjX + 3 >= 7 || adjY + 3 >= 6 || this.board[adj] != turn || this.board[adj + 7 + 1] != turn || this.board[adj + 14 + 2] != turn || this.board[adj + 21 + 3] != turn) continue;
                return true;
            }
            for (i = -3; i <= 0; ++i) {
                adjX = placedX + i;
                adjY = placedY - i;
                adj = adjX + adjY * 7;
                if (adj < 0 || adj >= 42 || adjX + 3 >= 7 || adjY - 3 < 0 || this.board[adj] != turn || this.board[adj - 7 + 1] != turn || this.board[adj - 14 + 2] != turn || this.board[adj - 21 + 3] != turn) continue;
                return true;
            }
            return false;
        }

        public List<Point> getAvailableStates() {
            ArrayList<Point> availablePoints = new ArrayList<Point>();
            for (int j = 0; j < 6; ++j) {
                for (int i = 0; i < 7; ++i) {
                    if (this.board[j * 7 + i] != 0 || j != 0 && this.board[(j - 1) * 7 + i] == 0) continue;
                    availablePoints.add(new Point(i, j));
                }
            }
            return availablePoints;
        }

        public int minimax(int depth, GameTurn turn, Point lastPlaced, int mistakeChance) {
            if (lastPlaced != null) {
                if (turn == GameTurn.PLAYER && this.hasWon(lastPlaced.x, lastPlaced.y, GameTurn.CPU)) {
                    return 1 - depth;
                }
                if (turn == GameTurn.CPU && this.hasWon(lastPlaced.x, lastPlaced.y, GameTurn.PLAYER)) {
                    return -1;
                }
            }
            if (depth > 7) {
                return 0;
            }
            List<Point> pointsAvailable = this.getAvailableStates();
            if (pointsAvailable.isEmpty()) {
                return 0;
            }
            if (depth == 0 && RewardsUtil.rand.nextInt(100) < mistakeChance) {
                this.computersMove = pointsAvailable.get(RewardsUtil.rand.nextInt(pointsAvailable.size()));
                return 0;
            }
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < pointsAvailable.size(); ++i) {
                Point point = pointsAvailable.get(i);
                this.placeMove(point.x, point.y, turn);
                int currentScore = this.minimax(depth + 1, turn == GameTurn.CPU ? GameTurn.PLAYER : GameTurn.CPU, point, mistakeChance);
                if (turn == GameTurn.CPU) {
                    max = Math.max(currentScore, max);
                    if (currentScore >= 0 && depth == 0) {
                        this.computersMove = point;
                    }
                    if (currentScore == 1) {
                        this.board[point.y * 7 + point.x] = 0;
                        break;
                    }
                    if (i == pointsAvailable.size() - 1 && max < 0 && depth == 0) {
                        this.computersMove = point;
                    }
                } else if (turn == GameTurn.PLAYER && (min = Math.min(currentScore, min)) == -1) {
                    this.board[point.y * 7 + point.x] = 0;
                    break;
                }
                this.board[point.y * 7 + point.x] = 0;
            }
            return turn == GameTurn.CPU ? max : min;
        }

        public void updateWorldView(Level level, BlockPos pos) {
            for (int z = -3; z < 4; ++z) {
                for (int y = 1; y < 7; ++y) {
                    level.setBlockAndUpdate(pos.offset(0, y, z), this.getStateForBoardVal(this.board[(y - 1) * 7 + (z + 3)]));
                }
            }
        }

        public BlockState getStateForBoardVal(int val) {
            return switch (val) {
                case 1 -> Blocks.YELLOW_CONCRETE_POWDER.defaultBlockState();
                case 2 -> Blocks.RED_CONCRETE_POWDER.defaultBlockState();
                default -> Blocks.AIR.defaultBlockState();
            };
        }
    }
}

