/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl.entries;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.MultilinePolicy;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class RegistryKeyValue
extends ConfigEntry.CollectionConfigEntry<ResourceLocation, Set<ResourceLocation>> {
    Registry<?> registry;
    Class<?> clz;
    Predicate<ResourceLocation> filter;

    public RegistryKeyValue(String key, Registry<?> registry, Class<?> clz, Set<ResourceLocation> defaultValue, Predicate<ResourceLocation> filter, String ... comment) {
        super(key, defaultValue, comment);
        this.registry = registry;
        this.clz = clz;
        this.filter = filter;
        this.addSuggestionProvider(new RegistryKeySuggestions(this));
    }

    public static <E> Builder<E> builder(String key, Class<E> clz) {
        return new Builder<E>(key, clz);
    }

    protected RegistryKeyValue copy() {
        return new RegistryKeyValue(this.getKey(), this.registry, this.clz, (Set)this.getDefault(), this.filter, this.getComment());
    }

    @Override
    protected String serializedValue(MultilinePolicy policy, Set<ResourceLocation> value) {
        String[] result = new String[value.size()];
        int i = 0;
        for (ResourceLocation entry : value) {
            result[i] = entry.toString();
        }
        return this.serializeArray(policy, result);
    }

    @Override
    public ParseResult<Set<ResourceLocation>> parseValue(String value) {
        String[] values = Helpers.splitArray(value, ",");
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int m = values.length;
        for (int i = 0; i < m; ++i) {
            ResourceLocation location = ResourceLocation.tryParse((String)values[i]);
            if (location == null || this.filter != null && !this.filter.test(location)) continue;
            result.add(location);
        }
        return ParseResult.success(result);
    }

    @Override
    public ParseResult<Boolean> canSet(Set<ResourceLocation> value) {
        ParseResult<Boolean> result = super.canSet(value);
        if (result.hasError()) {
            return result;
        }
        for (ResourceLocation entry : value) {
            if (!this.registry.containsKey(entry)) {
                return ParseResult.partial(false, NoSuchElementException::new, "Value [" + String.valueOf(entry) + "] doesn't exist in the registry");
            }
            if (this.filter == null || this.filter.test(entry)) continue;
            return ParseResult.partial(false, IllegalArgumentException::new, "Value [" + String.valueOf(entry) + "] isn't allowed");
        }
        return ParseResult.success(true);
    }

    private ParseResult<ResourceLocation> parseEntry(String value) {
        ResourceLocation location = ResourceLocation.tryParse((String)value);
        if (location == null) {
            return ParseResult.error(value, "Id [" + value + "] isn't a valid resource location");
        }
        if (!this.registry.containsKey(location) || this.filter != null && !this.filter.test(location)) {
            return ParseResult.error(value, "Id [" + value + "] isn't valid");
        }
        return ParseResult.success(location);
    }

    @Override
    public IStructuredData getDataType() {
        return StructureList.ListBuilder.variants(IStructuredData.EntryDataType.STRING, ResourceLocation.class, this::parseEntry, ResourceLocation::toString).addSuggestions(ISuggestionProvider.wrapper(this::getSuggestions)).build(true);
    }

    @Override
    public char getPrefix() {
        return 'K';
    }

    @Override
    public String getLimitations() {
        return "";
    }

    @Override
    public void serialize(IWriteBuffer buffer) {
        Set value = (Set)this.getValue();
        buffer.writeVarInt(value.size());
        for (ResourceLocation entry : value) {
            buffer.writeString(entry.toString());
        }
    }

    @Override
    protected void deserializeValue(IReadBuffer buffer) {
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation entry = ResourceLocation.tryParse((String)buffer.readString());
            if (entry == null) continue;
            result.add(entry);
        }
    }

    @Override
    protected Set<ResourceLocation> create(ResourceLocation value) {
        return ObjectSets.singleton((Object)value);
    }

    public static class RegistryKeySuggestions
    implements ISuggestionProvider {
        RegistryKeyValue value;

        public RegistryKeySuggestions(RegistryKeyValue value) {
            this.value = value;
        }

        @Override
        public void provideSuggestions(Consumer<ISuggestionProvider.Suggestion> output, Predicate<ISuggestionProvider.Suggestion> filter) {
            for (ResourceLocation entry : this.value.registry.keySet()) {
                String key = entry.toString();
                ISuggestionProvider.Suggestion suggestion = ISuggestionProvider.Suggestion.namedTypeValue(key, key, this.value.clz);
                if (!filter.test(suggestion)) continue;
                output.accept(suggestion);
            }
        }
    }

    public static class Builder<E> {
        Class<E> clz;
        String key;
        Set<E> unparsedValues = new ObjectLinkedOpenHashSet();
        Set<ResourceLocation> values = new ObjectLinkedOpenHashSet();
        Predicate<ResourceLocation> filter;
        String[] comments;

        private Builder(String key, Class<E> clz) {
            this.key = key;
            this.clz = clz;
        }

        public Builder<E> addDirectDefault(E ... elements) {
            this.unparsedValues.addAll((Collection<E>)ObjectArrayList.wrap((Object[])elements));
            return this;
        }

        public Builder<E> addDirectDefaults(Collection<E> elements) {
            this.unparsedValues.addAll(elements);
            return this;
        }

        public Builder<E> addDefault(ResourceLocation ... elements) {
            this.values.addAll((Collection<ResourceLocation>)ObjectArrayList.wrap((Object[])elements));
            return this;
        }

        public Builder<E> addDefaults(Collection<ResourceLocation> elements) {
            this.values.addAll(elements);
            return this;
        }

        public Builder<E> withFilter(Predicate<ResourceLocation> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<E> withComment(String ... comments) {
            this.comments = comments;
            return this;
        }

        private void parseValues(Registry<E> registry) {
            for (E entry : this.unparsedValues) {
                ResourceLocation location = registry.getKey(entry);
                if (location == null) continue;
                this.values.add(location);
            }
            this.unparsedValues.clear();
        }

        public RegistryKeyValue build(Registry<E> registry) {
            this.parseValues(registry);
            return new RegistryKeyValue(this.key, registry, this.clz, this.values, this.filter, this.comments);
        }

        public RegistryKeyValue build(Registry<E> registry, ConfigSection section) {
            this.parseValues(registry);
            return section.add(new RegistryKeyValue(this.key, registry, this.clz, this.values, this.filter, this.comments));
        }
    }
}

