/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.api;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public interface IEntrySettings {
    default public <T> T get(Class<T> clz) {
        return clz.isInstance(this) ? (T)clz.cast(this) : null;
    }

    default public <T> void forEachType(Class<T> clz, Consumer<T> scanner) {
        if (clz.isInstance(this)) {
            scanner.accept(clz.cast(this));
        }
    }

    public static IEntrySettings compound(IEntrySettings ... settings) {
        return new CompoundEntrySettings((List<IEntrySettings>)ObjectArrayList.wrap((Object[])settings));
    }

    public static IEntrySettings merge(IEntrySettings original, IEntrySettings toAdd) {
        if (original == null) {
            return toAdd;
        }
        if (toAdd == null) {
            return original;
        }
        if (original instanceof CompoundEntrySettings) {
            ((CompoundEntrySettings)original).merge(toAdd);
            return original;
        }
        if (toAdd instanceof CompoundEntrySettings) {
            ((CompoundEntrySettings)original).merge(toAdd);
            return toAdd;
        }
        if (original.getClass() == toAdd.getClass()) {
            return toAdd;
        }
        return new CompoundEntrySettings((List<IEntrySettings>)ObjectArrayList.wrap((Object[])new IEntrySettings[]{original, toAdd}));
    }

    public static class CompoundEntrySettings
    implements IEntrySettings {
        Map<Class<?>, IEntrySettings> settings = Object2ObjectMap.builder().map();

        public CompoundEntrySettings(List<IEntrySettings> settings) {
            for (IEntrySettings setting : settings) {
                this.settings.put(setting.getClass(), setting);
            }
        }

        public CompoundEntrySettings(Map<Class<?>, IEntrySettings> settings) {
            this.settings.putAll(settings);
        }

        private void merge(IEntrySettings settings) {
            if (settings instanceof CompoundEntrySettings) {
                this.settings.putAll(((CompoundEntrySettings)settings).settings);
                return;
            }
            this.settings.put(settings.getClass(), settings);
        }

        @Override
        public <T> T get(Class<T> clz) {
            IEntrySettings setting = this.settings.get(clz);
            return setting == null ? null : (T)clz.cast(setting);
        }

        @Override
        public <T> void forEachType(Class<T> clz, Consumer<T> scanner) {
            for (IEntrySettings setting : this.settings.values()) {
                setting.forEachType(clz, scanner);
            }
        }
    }

    public static class TranslatedKey
    implements IEntrySettings {
        String translationKey;

        public TranslatedKey(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static class TranslatedComment
    implements IEntrySettings {
        String translationKey;

        public TranslatedComment(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

