/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class ContainerBCTile<T extends TileBCore>
extends ModularGuiContainerMenu {
    public T tile;
    public Player player;
    private boolean initComplete = false;

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super(type, windowId, playerInv);
        this.player = playerInv.player;
        this.tile = (TileBCore)ContainerBCTile.getClientTile(playerInv, extraData);
    }

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory playerInv, T tile) {
        super(type, windowId, playerInv);
        this.player = playerInv.player;
        this.tile = tile;
        ((TileBCore)this.tile).onPlayerOpenContainer(playerInv.player);
    }

    public void removed(Player player) {
        super.removed(player);
        ((TileBCore)this.tile).onPlayerCloseContainer(player);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.initComplete) {
            ((TileBCore)this.tile).detectAndSendChanges(true);
        }
    }

    public void onOpened(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((TileBCore)this.tile).getDataManager().forcePlayerSync(serverPlayer);
            this.initComplete = true;
        }
    }

    public boolean stillValid(Player player) {
        if (this.tile.getLevel().getBlockEntity(this.tile.getBlockPos()) != this.tile) {
            return false;
        }
        return player.distanceToSqr((double)this.tile.getBlockPos().getX() + 0.5, (double)this.tile.getBlockPos().getY() + 0.5, (double)this.tile.getBlockPos().getZ() + 0.5) <= (double)((TileBCore)this.tile).getAccessDistanceSq();
    }

    public Slot getSlot(int slotId) {
        if (slotId < this.slots.size() && slotId >= 0) {
            return (Slot)this.slots.get(slotId);
        }
        return null;
    }

    protected static <T extends BlockEntity> T getClientTile(Inventory playerInv, FriendlyByteBuf extraData) {
        return (T)playerInv.player.level().getBlockEntity(extraData.readBlockPos());
    }

    public PacketCustom createServerBoundPacket(int packetType) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL_NAME, packetType, this.tile.getLevel().registryAccess());
        packet.writeInt(this.containerId);
        return packet;
    }

    public void handleContainerMessage(PacketCustom packet, ServerPlayer player) {
        int containerId = packet.readInt();
        if (containerId != this.containerId) {
            return;
        }
        byte packetID = packet.readByte();
        ((TileBCore)this.tile).receivePacketFromClient((MCDataInput)packet, player, packetID);
    }

    public void handleTileDataPacket(PacketCustom packet, ServerPlayer player) {
        int containerId = packet.readInt();
        if (containerId != this.containerId) {
            return;
        }
        ((TileBCore)this.tile).getDataManager().receiveDataFromClient((MCDataInput)packet);
    }
}

