/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiList;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

public class GuiListDialog<T>
extends GuiElement<GuiListDialog<T>> {
    protected GuiList<T> list;
    protected GuiSlider scrollBar;
    private boolean closeOnItemClicked = false;
    private boolean closeOnOutsideClick = true;
    private boolean actionOnClick = false;
    private Function<T, String> searchStringFunc = t -> this.toString();

    public GuiListDialog(ModularGui gui) {
        super((GuiParent)gui.getRoot());
        this.jeiExclude();
        this.setOpaque(true);
    }

    public static <C> GuiListDialog<C> create(GuiParent<?> parent) {
        return GuiListDialog.create(parent, GuiRectangle::toolTipBackground);
    }

    public static <C> GuiListDialog<C> create(GuiParent<?> parent, Function<GuiListDialog<C>, GuiElement<?>> backgroundFunc) {
        GuiListDialog dialog = new GuiListDialog(parent.getModularGui());
        Constraints.bind((ConstrainedGeometry)((ConstrainedGeometry)backgroundFunc.apply(dialog)), dialog);
        dialog.list = (GuiList)((GuiList)((GuiList)((GuiList)((GuiList)new GuiList(dialog).setZStacking(false)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.RIGHT), () -> dialog.list.hiddenSize() > 0.0 ? -8.0 : -3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.BOTTOM), (double)-15.0));
        dialog.scrollBar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider(dialog, Axis.Y).setEnabled(() -> dialog.list.hiddenSize() > 0.0)).setSliderState(dialog.list.scrollState()).setScrollableElement(dialog.list).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)dialog.list.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)dialog.list.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)dialog.list.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)dialog.scrollBar).fill(0x20FFFFFF), (ConstrainedGeometry)dialog.scrollBar);
        dialog.scrollBar.installSlider((GuiElement)new GuiRectangle((GuiParent)dialog.scrollBar).fill(0x50FFFFFF)).bindSliderLength().bindSliderWidth();
        GuiRectangle searchBg = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle(dialog).fill(0x20FFFFFF).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)dialog.list.get(GeoParam.BOTTOM), (double)1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.BOTTOM), (double)-3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.RIGHT), (double)-3.0));
        GuiTextField search = new GuiTextField((GuiParent)searchBg).setSuggestion((Component)Component.translatable((String)"mod_gui.brandonscore.list_dialog.search")).setTextState(TextState.simpleState((String)"", s -> dialog.list.markDirty()));
        Constraints.bind((ConstrainedGeometry)search, (ConstrainedGeometry)searchBg, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        dialog.list.setFilter(c -> search.getValue().isEmpty() || dialog.searchStringFunc.apply(c).toLowerCase(Locale.ROOT).contains(search.getValue().toLowerCase(Locale.ROOT)));
        return dialog;
    }

    public static <C> GuiListDialog<C> createNoSearch(GuiParent<?> parent) {
        return GuiListDialog.createNoSearch(parent, GuiRectangle::toolTipBackground);
    }

    public static <C> GuiListDialog<C> createNoSearch(GuiParent<?> parent, Function<GuiListDialog<C>, GuiElement<?>> backgroundFunc) {
        GuiListDialog dialog = new GuiListDialog(parent.getModularGui());
        Constraints.bind((ConstrainedGeometry)((ConstrainedGeometry)backgroundFunc.apply(dialog)), dialog);
        dialog.list = (GuiList)((GuiList)((GuiList)((GuiList)((GuiList)new GuiList(dialog).setZStacking(false)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.RIGHT), () -> dialog.list.hiddenSize() > 0.0 ? -8.0 : -3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)dialog.get(GeoParam.BOTTOM), (double)-3.0));
        dialog.scrollBar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider(dialog, Axis.Y).setEnabled(() -> dialog.list.hiddenSize() > 0.0)).setSliderState(dialog.list.scrollState()).setScrollableElement(dialog.list).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)dialog.list.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)dialog.list.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)dialog.list.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)dialog.scrollBar).fill(0x20FFFFFF), (ConstrainedGeometry)dialog.scrollBar);
        dialog.scrollBar.installSlider((GuiElement)new GuiRectangle((GuiParent)dialog.scrollBar).fill(0x50FFFFFF)).bindSliderLength().bindSliderWidth();
        return dialog;
    }

    public GuiList<T> getList() {
        return this.list;
    }

    public GuiListDialog<T> addItems(Collection<T> items) {
        this.list.getList().addAll(items);
        this.list.markDirty();
        return this;
    }

    public GuiListDialog<T> addItems(T ... items) {
        return this.addItems((Collection<T>)List.of(items));
    }

    public GuiListDialog<T> setCloseOnItemClicked(boolean closeOnItemClicked) {
        this.closeOnItemClicked = closeOnItemClicked;
        return this;
    }

    public GuiListDialog<T> setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return this;
    }

    public GuiListDialog<T> setSearchStringFunc(Function<T, String> searchStringFunc) {
        this.searchStringFunc = searchStringFunc;
        return this;
    }

    public GuiListDialog<T> actionOnClick() {
        this.actionOnClick = true;
        return this;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseClicked(mouseX, mouseY, button, consumed);
        if (this.isMouseOver() || consumed) {
            if (this.actionOnClick) {
                if (consumed && this.closeOnItemClicked) {
                    this.close();
                }
                return true;
            }
        } else if (this.closeOnOutsideClick) {
            this.close();
            return true;
        }
        return consumed;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseReleased(mouseX, mouseY, button, consumed);
        if ((this.isMouseOver() || consumed) && !this.actionOnClick) {
            if (consumed && this.closeOnItemClicked) {
                this.close();
            }
            return true;
        }
        return consumed;
    }

    public void close() {
        this.getParent().removeChild((GuiElement)this);
    }

    public GuiListDialog<T> setNormalizedPos(double x, double y) {
        this.constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> Math.min(Math.max(x, 0.0), (double)this.scaledScreenWidth() - this.xSize())));
        this.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> Math.min(Math.max(y, 0.0), (double)this.scaledScreenHeight() - this.ySize())));
        return this;
    }

    public GuiListDialog<T> placeCenter() {
        this.constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> ((double)this.scaledScreenWidth() - this.xSize()) / 2.0));
        this.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> ((double)this.scaledScreenHeight() - this.ySize()) / 2.0));
        return this;
    }
}

