/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.inventory;

import java.util.Optional;
import net.byAqua3.avaritia.inventory.ContainerExtremeCrafting;
import net.byAqua3.avaritia.inventory.slot.SlotExtremeResult;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaMenus;
import net.byAqua3.avaritia.loader.AvaritiaRecipes;
import net.byAqua3.avaritia.tile.TileExtremeCraftingTable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MenuExtremeCrafting
extends AbstractContainerMenu {
    private final Player player;
    private final TileExtremeCraftingTable tile;
    private final ContainerExtremeCrafting craftSlots;
    private final ResultContainer resultContainer = new ResultContainer();
    private final SlotExtremeResult resultSlot;

    public MenuExtremeCrafting(int id, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(id, inventory, (TileExtremeCraftingTable)inventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()));
    }

    public MenuExtremeCrafting(int id, Inventory inventory, TileExtremeCraftingTable tile) {
        super((MenuType)AvaritiaMenus.EXTREME_CRAFTING.get(), id);
        int i;
        int y;
        this.player = inventory.player;
        this.tile = tile;
        this.craftSlots = new ContainerExtremeCrafting(this, 9, 9, tile.matrix);
        this.resultSlot = new SlotExtremeResult(this.player, (CraftingContainer)this.craftSlots, (Container)this.resultContainer, 0, 210, 80);
        this.addSlot((Slot)this.resultSlot);
        for (y = 0; y < 9; ++y) {
            for (i = 0; i < 9; ++i) {
                this.addSlot(new Slot((Container)this.craftSlots, i + y * 9, 12 + i * 18, 8 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (i = 0; i < 9; ++i) {
                this.addSlot(new Slot((Container)inventory, i + y * 9 + 9, 39 + i * 18, 174 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 39 + x * 18, 232));
        }
        this.slotsChanged((Container)this.craftSlots);
    }

    public void slotsChanged(Container container) {
        Level level = this.tile.getLevel();
        if (level.isClientSide()) {
            return;
        }
        ItemStack itemStack = ItemStack.EMPTY;
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)AvaritiaRecipes.EXTREME_CRAFTING.get(), (RecipeInput)((ContainerExtremeCrafting)container).asCraftInput(), level);
        if (recipe.isPresent()) {
            this.resultSlot.setUsedRecipe((Recipe<CraftingInput>)((RecipeHolder)recipe.get()).value());
            itemStack = ((RecipeHolder)recipe.get()).value().assemble((RecipeInput)this.craftSlots.asCraftInput(), (HolderLookup.Provider)level.registryAccess());
        } else {
            this.resultSlot.setUsedRecipe(null);
        }
        this.resultContainer.setItem(0, itemStack);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            resultStack = slotStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(slotStack, 82, 118, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, resultStack);
            } else if (index >= 82 && index < 118 ? !this.moveItemStackTo(slotStack, 1, 82, false) && (index < 109 ? !this.moveItemStackTo(slotStack, 109, 118, false) : !this.moveItemStackTo(slotStack, 82, 109, false)) : !this.moveItemStackTo(slotStack, 82, 118, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == resultStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return resultStack;
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.tile.getBlockPos();
        return this.tile.getLevel().getBlockState(pos).is((Block)AvaritiaBlocks.EXTREME_CRAFTING_TABLE.get()) && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }
}

