/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.byAqua3.avaritia.tile.TileInfinityChest;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class ClusterContainerContents {
    private static final int NO_SLOT = -1;
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    public static final ClusterContainerContents EMPTY = new ClusterContainerContents((NonNullList<ItemStack>)NonNullList.create());
    public static final Codec<ClusterContainerContents> CODEC = Slot.CODEC.sizeLimitedListOf(Integer.MAX_VALUE).xmap(ClusterContainerContents::fromSlots, ClusterContainerContents::asSlots);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClusterContainerContents> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)Integer.MAX_VALUE)).map(ClusterContainerContents::new, p_331691_ -> p_331691_.items);
    private final NonNullList<ItemStack> items;
    private final int hashCode;

    private ClusterContainerContents(NonNullList<ItemStack> items) {
        if (items.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Got " + items.size() + " items, but maximum is " + String.valueOf(Integer.MAX_VALUE));
        }
        this.items = items;
        this.hashCode = ItemStack.hashStackList(items);
    }

    private ClusterContainerContents(int size) {
        this((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    private ClusterContainerContents(List<ItemStack> items) {
        this(items.size());
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, (Object)items.get(i));
        }
    }

    private static ClusterContainerContents fromSlots(List<Slot> slots) {
        OptionalInt optionalint = slots.stream().mapToInt(Slot::index).max();
        if (optionalint.isEmpty()) {
            return EMPTY;
        }
        ClusterContainerContents itemcontainercontents = new ClusterContainerContents(optionalint.getAsInt() + 1);
        for (Slot itemcontainercontents$slot : slots) {
            itemcontainercontents.items.set(itemcontainercontents$slot.index(), (Object)itemcontainercontents$slot.item());
        }
        return itemcontainercontents;
    }

    public static ClusterContainerContents fromItems(List<ItemStack> items) {
        int i = ClusterContainerContents.findLastNonEmptySlot(items);
        if (i == -1) {
            return EMPTY;
        }
        ClusterContainerContents itemcontainercontents = new ClusterContainerContents(i + 1);
        for (int j = 0; j <= i; ++j) {
            itemcontainercontents.items.set(j, (Object)items.get(j).copy());
        }
        return itemcontainercontents;
    }

    private static int findLastNonEmptySlot(List<ItemStack> items) {
        for (int i = items.size() - 1; i >= 0; --i) {
            if (items.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.isEmpty()) continue;
            list.add(new Slot(i, itemStack));
        }
        return list;
    }

    public void copyInto(NonNullList<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemStack = i < this.items.size() ? (ItemStack)this.items.get(i) : ItemStack.EMPTY;
            list.set(i, (Object)itemStack.copy());
        }
    }

    public ItemStack copyOne() {
        return this.items.isEmpty() ? ItemStack.EMPTY : ((ItemStack)this.items.get(0)).copy();
    }

    public Stream<ItemStack> stream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Stream<ItemStack> nonEmptyStream() {
        return this.items.stream().filter(itemStack -> !itemStack.isEmpty()).map(ItemStack::copy);
    }

    public Iterable<ItemStack> nonEmptyItems() {
        return Iterables.filter(this.items, itemStack -> !itemStack.isEmpty());
    }

    public Iterable<ItemStack> nonEmptyItemsCopy() {
        return Iterables.transform(this.nonEmptyItems(), ItemStack::copy);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof ClusterContainerContents) {
            ClusterContainerContents itemcontainercontents = (ClusterContainerContents)pOther;
            if (ItemStack.listMatches(this.items, itemcontainercontents.items)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getSlots() {
        return this.items.size();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((ItemStack)this.items.get(slot)).copy();
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new UnsupportedOperationException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    record Slot(int index, ItemStack item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(p_331695_ -> p_331695_.group((App)Codec.intRange((int)0, (int)0x7FFFFFFE).fieldOf("slot").forGetter(Slot::index), (App)TileInfinityChest.CODEC.fieldOf("item").forGetter(Slot::item)).apply((Applicative)p_331695_, Slot::new));
    }
}

