/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.byAqua3.avaritia.inventory.MenuInfinityChest;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.tile.TileInfinityChest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockInfinityChest
extends BaseEntityBlock
implements EntityBlock {
    public static final Component TITLE = Component.translatable((String)"avaritia:container.infinity_chest.title");
    public static final MapCodec<BlockInfinityChest> CODEC = BlockInfinityChest.simpleCodec(properties -> new BlockInfinityChest((BlockBehaviour.Properties)properties));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.CHEST_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    protected static final int AABB_OFFSET = 1;
    protected static final int AABB_HEIGHT = 14;
    protected static final VoxelShape NORTH_AABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public BlockInfinityChest(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)ChestType.SINGLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileInfinityChest(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facingState.is((Block)this) && facing.getAxis().isHorizontal()) {
            ChestType chesttype = (ChestType)facingState.getValue(TYPE);
            if (state.getValue(TYPE) == ChestType.SINGLE) {
                return (BlockState)state.setValue(TYPE, (Comparable)chesttype.getOpposite());
            }
        } else {
            return (BlockState)state.setValue(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = context.getHorizontalDirection().getOpposite();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(TYPE, (Comparable)chesttype)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(direction));
        return blockstate.is((Block)this) && blockstate.getValue(TYPE) == ChestType.SINGLE ? (Direction)blockstate.getValue((Property)FACING) : null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        BlockState rotated = state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
        return mirror == Mirror.NONE ? rotated : (BlockState)rotated.setValue(TYPE, (Comparable)((ChestType)rotated.getValue(TYPE)).getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof TileInfinityChest) {
            TileInfinityChest tile = (TileInfinityChest)blockEntity;
            SimpleMenuProvider simpleMenuProvider = new SimpleMenuProvider((id, inventory, access) -> new MenuInfinityChest(id, inventory, tile), TITLE);
            player.openMenu((MenuProvider)simpleMenuProvider, pos);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? BlockInfinityChest.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)AvaritiaBlocks.INFINITY_CHEST_TILE.get()), TileInfinityChest::lidAnimateTick) : null;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileInfinityChest) {
            TileInfinityChest tile = (TileInfinityChest)blockEntity;
            tile.recheckOpen();
        }
    }
}

