/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.IModdedBook;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.Registries;
import vazkii.akashictome.data_components.ToolContentComponent;

public class AttachementRecipe
extends CustomRecipe {
    public AttachementRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean foundTool = false;
        boolean foundTarget = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (this.isTarget(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.is((Item)Registries.TOME.get())) {
                if (foundTool) {
                    return false;
                }
                foundTool = true;
                continue;
            }
            return false;
        }
        return foundTool && foundTarget;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack tool = ItemStack.EMPTY;
        ItemStack target = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is((Item)Registries.TOME.get())) {
                tool = stack;
                continue;
            }
            target = stack;
        }
        if (!tool.has(Registries.TOOL_CONTENT)) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = tool.copy();
        ToolContentComponent contents = (ToolContentComponent)copy.get(Registries.TOOL_CONTENT);
        if (contents == null) {
            return ItemStack.EMPTY;
        }
        Object mod = MorphingHandler.getModFromStack(target);
        String modRoot = mod;
        for (int tries = 0; contents.hasDefinedMod((String)mod) && tries < 99; ++tries) {
            mod = modRoot + "_" + tries;
        }
        target.set(Registries.DEFINED_MOD, mod);
        ToolContentComponent.Mutable mutable = new ToolContentComponent.Mutable(contents);
        if (!target.isEmpty()) {
            mutable.tryInsert(target);
        }
        copy.set(Registries.TOOL_CONTENT, (Object)mutable.toImmutable());
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public boolean isTarget(ItemStack stack) {
        if (stack.isEmpty() || MorphingHandler.isAkashicTome(stack)) {
            return false;
        }
        String mod = MorphingHandler.getModFromStack(stack);
        if (mod.equals("minecraft")) {
            return false;
        }
        if (((Boolean)ConfigHandler.allItems.get()).booleanValue()) {
            return true;
        }
        if (((List)ConfigHandler.blacklistedMods.get()).contains(mod)) {
            return false;
        }
        if (stack.getItem() instanceof IModdedBook) {
            return true;
        }
        ResourceLocation registryNameRL = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String registryName = registryNameRL.toString();
        if (((List)ConfigHandler.whitelistedItems.get()).contains(registryName) || ((List)ConfigHandler.whitelistedItems.get()).contains(registryName + ":" + stack.getDamageValue())) {
            return true;
        }
        if (((List)ConfigHandler.blacklistedItems.get()).contains(registryName) || ((List)ConfigHandler.blacklistedItems.get()).contains(registryName + ":" + stack.getDamageValue())) {
            return false;
        }
        String itemName = registryNameRL.getPath().toLowerCase();
        for (String s : (List)ConfigHandler.whitelistedNames.get()) {
            if (!itemName.contains(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInput) {
        return NonNullList.withSize((int)craftingInput.size(), (Object)ItemStack.EMPTY);
    }

    public RecipeSerializer<?> getSerializer() {
        return Registries.ATTACHMENT.get();
    }
}

