/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.NetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.lua.ObjectLuaTable;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSCraftJob;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSFluidHandler;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSItemHandler;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSMekanismApi;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RsStorageTypes;
import de.srendi.advancedperipherals.common.blocks.blockentities.RSBridgeEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.EmptyLuaTable;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.StatusConstants;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemPeripheral;
import de.srendi.advancedperipherals.common.util.inventory.InventoryUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.List;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSBridgePeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<RSBridgeEntity>>
implements IStorageSystemPeripheral {
    public static final String PERIPHERAL_TYPE = "rs_bridge";
    private final RSBridgeEntity bridge;

    public RSBridgePeripheral(RSBridgeEntity owner) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<RSBridgeEntity>(owner));
        this.bridge = owner;
    }

    @Override
    public boolean isEnabled() {
        return APAddon.REFINEDSTORAGE.isLoaded() && (Boolean)APConfig.PERIPHERALS_CONFIG.enableRSBridge.get() != false;
    }

    private AbstractNetworkNode getNode() {
        return (AbstractNetworkNode)((RSBridgeEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).getNode();
    }

    public Network getNetwork() {
        return this.getNode().getNetwork();
    }

    private MethodResult notConnected(@Nullable Object defaultValue) {
        return MethodResult.of((Object[])new Object[]{defaultValue, StatusConstants.NOT_CONNECTED.toString()});
    }

    private <I extends NetworkComponent> I getComponent(@NotNull Class<I> componentClass) {
        return (I)((NetworkComponent)this.getNetwork().getComponent(componentClass));
    }

    private boolean isAvailable() {
        return true;
    }

    protected MethodResult exportToChest(@NotNull IArguments arguments, @Nullable IItemHandler targetInventory) throws LuaException {
        RSItemHandler itemHandler = new RSItemHandler(this.getNetwork());
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        if (targetInventory == null) {
            return MethodResult.of((Object[])new Object[]{0, "Target Inventory does not exist"});
        }
        return MethodResult.of((Object)InventoryUtil.moveItem(itemHandler, targetInventory, filter.getLeft()));
    }

    protected MethodResult exportToTank(@NotNull IArguments arguments, @Nullable IFluidHandler targetTank) throws LuaException {
        RSFluidHandler fluidHandler = new RSFluidHandler(this.getNetwork());
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        if (targetTank == null) {
            return MethodResult.of((Object[])new Object[]{0, "Target Tank does not exist"});
        }
        return MethodResult.of((Object)FluidUtil.moveFluid(fluidHandler, targetTank, filter.getLeft()));
    }

    protected MethodResult importToRS(@NotNull IArguments arguments, @Nullable IItemHandler targetInventory) throws LuaException {
        RSItemHandler itemHandler = new RSItemHandler(this.getNetwork());
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        if (targetInventory == null) {
            return MethodResult.of((Object[])new Object[]{0, "Target Inventory does not exist"});
        }
        return MethodResult.of((Object)InventoryUtil.moveItem(targetInventory, itemHandler, filter.getLeft()));
    }

    protected MethodResult importToRS(@NotNull IArguments arguments, @Nullable IFluidHandler targetTank) throws LuaException {
        RSFluidHandler fluidHandler = new RSFluidHandler(this.getNetwork());
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        if (targetTank == null) {
            return MethodResult.of((Object[])new Object[]{0, "Target Tank does not exist"});
        }
        return MethodResult.of((Object)FluidUtil.moveFluid(targetTank, fluidHandler, filter.getLeft()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final boolean isConnected() {
        return this.isAvailable();
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult isOnline() {
        if (!this.isAvailable()) {
            return this.notConnected(false);
        }
        return MethodResult.of((Object)(this.getComponent(EnergyNetworkComponent.class).getStored() > 0L ? 1 : 0));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getItem(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, "EMPTY_FILTER"});
        }
        Map<String, Object> resourceProperties = RSApi.getParsedItem(this.getNetwork(), parsedFilter);
        if (resourceProperties == null) {
            return MethodResult.of((Object[])new Object[]{null, "NOT_FOUND"});
        }
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getFluid(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, "EMPTY_FILTER"});
        }
        Map<String, Object> resourceProperties = RSApi.getParsedFluid(this.getNetwork(), parsedFilter);
        if (resourceProperties == null) {
            return MethodResult.of((Object[])new Object[]{null, "NOT_FOUND"});
        }
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getChemical(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.REFINEDSTORAGE_MEKANISM)});
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ChemicalFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, "EMPTY_FILTER"});
        }
        Map<String, Object> resourceProperties = RSApi.getParsedChemical(this.getNetwork(), parsedFilter);
        if (resourceProperties == null) {
            return MethodResult.of((Object[])new Object[]{null, "NOT_FOUND"});
        }
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getItems(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        List<Map<String, Object>> resourceProperties = RSApi.getParsedItems(this.getNetwork(), parsedFilter);
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getFluids(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidFilter parsedFilter = filter.getLeft();
        List<Map<String, Object>> resourceProperties = RSApi.getParsedFluids(this.getNetwork(), parsedFilter);
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getChemicals(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo("RS_MEKANISM")});
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ChemicalFilter parsedFilter = filter.getLeft();
        List<Map<String, Object>> resourceProperties = RSApi.getParsedChemicals(this.getNetwork(), parsedFilter);
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCraftableItems(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        List<Map<String, Object>> resourceProperties = RSApi.getCraftableItems(this.getNetwork(), parsedFilter);
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCraftableFluids(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidFilter parsedFilter = filter.getLeft();
        List<Map<String, Object>> resourceProperties = RSApi.getCraftableFluids(this.getNetwork(), parsedFilter);
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCraftableChemicals(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.REFINEDSTORAGE_MEKANISM)});
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ChemicalFilter parsedFilter = filter.getLeft();
        List<Map<String, Object>> resourceProperties = RSApi.getCraftableChemicals(this.getNetwork(), parsedFilter);
        return MethodResult.of(resourceProperties);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCells() {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        return MethodResult.of(RSApi.listCells(this.getNetwork()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getDrives() {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        return MethodResult.of(RSApi.listDrives(this.getNetwork()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult importItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        if (inventory == null && (inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1))) == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.importToRS(arguments, inventory);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult exportItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        if (inventory == null && (inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1))) == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.exportToChest(arguments, inventory);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult importFluid(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        IFluidHandler handler = FluidUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        if (handler == null && (handler = FluidUtil.getHandlerFromName(computer, arguments.getString(1))) == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.importToRS(arguments, handler);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult exportFluid(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        IFluidHandler handler = FluidUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        if (handler == null && (handler = FluidUtil.getHandlerFromName(computer, arguments.getString(1))) == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.exportToTank(arguments, handler);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult importChemical(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.REFINEDSTORAGE_MEKANISM)});
        }
        return RSMekanismApi.importToRS(arguments, computer, this);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult exportChemical(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.REFINEDSTORAGE_MEKANISM)});
        }
        return RSMekanismApi.exportToTank(arguments, computer, this);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getStoredEnergy() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        EnergyNetworkComponent energyComponent = (EnergyNetworkComponent)this.getNetwork().getComponent(EnergyNetworkComponent.class);
        return MethodResult.of((Object)energyComponent.getStored());
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyCapacity() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        EnergyNetworkComponent energyComponent = (EnergyNetworkComponent)this.getNetwork().getComponent(EnergyNetworkComponent.class);
        return MethodResult.of((Object)energyComponent.getCapacity());
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyUsage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getEnergyUsage(this.getNetwork()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAverageEnergyInput() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)0);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalExternalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getTotalExternalStorage(this.getNetwork(), RsStorageTypes.ITEM));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalExternalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getTotalExternalStorage(this.getNetwork(), RsStorageTypes.FLUID));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalExternalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo("RS_MEKANISM")});
        }
        return MethodResult.of((Object)RSApi.getTotalExternalStorage(this.getNetwork(), RsStorageTypes.CHEMICAL));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getTotalStorage(this.getNetwork(), RsStorageTypes.ITEM));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getTotalStorage(this.getNetwork(), RsStorageTypes.FLUID));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo("RS_MEKANISM")});
        }
        return MethodResult.of((Object)RSApi.getTotalStorage(this.getNetwork(), RsStorageTypes.CHEMICAL));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedExternalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getUsedExternalStorage(this.getNetwork(), RsStorageTypes.ITEM));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedExternalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getUsedExternalStorage(this.getNetwork(), RsStorageTypes.FLUID));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedExternalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo("RS_MEKANISM")});
        }
        return MethodResult.of((Object)RSApi.getUsedExternalStorage(this.getNetwork(), RsStorageTypes.CHEMICAL));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getUsedStorage(this.getNetwork(), RsStorageTypes.ITEM));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)RSApi.getUsedStorage(this.getNetwork(), RsStorageTypes.FLUID));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo("RS_MEKANISM")});
        }
        return MethodResult.of((Object)RSApi.getUsedStorage(this.getNetwork(), RsStorageTypes.CHEMICAL));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableExternalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)(RSApi.getTotalExternalStorage(this.getNetwork(), RsStorageTypes.ITEM) - RSApi.getUsedExternalStorage(this.getNetwork(), RsStorageTypes.ITEM)));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableExternalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)(RSApi.getTotalExternalStorage(this.getNetwork(), RsStorageTypes.FLUID) - RSApi.getUsedExternalStorage(this.getNetwork(), RsStorageTypes.FLUID)));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableExternalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo("RS_MEKANISM")});
        }
        return MethodResult.of((Object)(RSApi.getTotalExternalStorage(this.getNetwork(), RsStorageTypes.CHEMICAL) - RSApi.getUsedExternalStorage(this.getNetwork(), RsStorageTypes.CHEMICAL)));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)(RSApi.getTotalStorage(this.getNetwork(), RsStorageTypes.ITEM) - RSApi.getUsedStorage(this.getNetwork(), RsStorageTypes.ITEM)));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)(RSApi.getTotalStorage(this.getNetwork(), RsStorageTypes.FLUID) - RSApi.getUsedStorage(this.getNetwork(), RsStorageTypes.FLUID)));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.ADDON_NOT_LOADED.withInfo("RS_MEKANISM")});
        }
        return MethodResult.of((Object)(RSApi.getTotalStorage(this.getNetwork(), RsStorageTypes.CHEMICAL) - RSApi.getUsedStorage(this.getNetwork(), RsStorageTypes.CHEMICAL)));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult craftItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        RSCraftJob job = new RSCraftJob(computer, this.getLevel(), filter.getLeft().getCount(), (ResourceKey)ItemResource.ofItemStack((ItemStack)filter.getLeft().toItemStack()), (AutocraftingNetworkComponent)this.getNetwork().getComponent(AutocraftingNetworkComponent.class));
        this.bridge.addJob(job);
        return MethodResult.of((Object)job);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult craftFluid(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        RSCraftJob job = new RSCraftJob(computer, this.getLevel(), filter.getLeft().getCount(), (ResourceKey)VariantUtil.ofFluidStack((FluidStack)filter.getLeft().toFluidStack()), (AutocraftingNetworkComponent)this.getNetwork().getComponent(AutocraftingNetworkComponent.class));
        this.bridge.addJob(job);
        return MethodResult.of((Object)job);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult craftChemical(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.REFINEDSTORAGE_MEKANISM.name())});
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        RSCraftJob job = new RSCraftJob(computer, this.getLevel(), filter.getLeft().getCount(), (ResourceKey)ChemicalResource.ofChemicalStack((ChemicalStack)filter.getLeft().toChemicalStack()), (AutocraftingNetworkComponent)this.getNetwork().getComponent(AutocraftingNetworkComponent.class));
        this.bridge.addJob(job);
        return MethodResult.of((Object)job);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCraftingTasks() {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        return MethodResult.of(RSApi.getCraftingTasks(this.getNetwork(), this.bridge));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCraftingTask(int id) {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        for (RSCraftJob job : this.bridge.getJobs()) {
            if (job.getId() != (long)id) continue;
            return MethodResult.of((Object)job);
        }
        return MethodResult.of((Object[])new Object[]{null, StatusConstants.NOT_FOUND});
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult cancelCraftingTasks(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        Pair<GenericFilter<?>, String> filter = GenericFilter.parseGeneric(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.getRight() != null) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        GenericFilter<?> parsedFilter = filter.getLeft();
        AutocraftingNetworkComponent craftingManager = this.getComponent(AutocraftingNetworkComponent.class);
        int canceled = 0;
        for (TaskStatus status : craftingManager.getStatuses()) {
            if (!parsedFilter.testRS(new ResourceAmount(status.info().resource(), 1L))) continue;
            craftingManager.cancel(status.info().id());
            ++canceled;
        }
        return MethodResult.of((Object)canceled);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult isCraftable(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(false);
        }
        Pair<GenericFilter<?>, String> filter = GenericFilter.parseGeneric(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.getRight() != null) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        GenericFilter<?> parsedFilter = filter.getLeft();
        return MethodResult.of((Object)RSApi.findPatternFromFilters(this.getNetwork(), null, parsedFilter).leftPresent());
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult isCrafting(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(false);
        }
        Pair<GenericFilter<?>, String> filter = GenericFilter.parseGeneric(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.getRight() != null) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        GenericFilter<?> parsedFilter = filter.getLeft();
        AutocraftingNetworkComponent craftingManager = this.getComponent(AutocraftingNetworkComponent.class);
        for (TaskStatus status : craftingManager.getStatuses()) {
            if (!parsedFilter.testRS(new ResourceAmount(status.info().resource(), 1L))) continue;
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getPatterns(IArguments arguments) throws LuaException {
        Pair<Pattern, String> pattern;
        Pair<GenericFilter<?>, String> parsedFilter;
        boolean hasAnyFilter;
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        LuaTable<Object, Object> filterTable = EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null));
        if (filterTable.isEmpty()) {
            return MethodResult.of(RSApi.getPatterns(this.getNetwork()));
        }
        boolean hasInputFilter = filterTable.containsKey((Object)"input");
        boolean hasOutputFilter = filterTable.containsKey((Object)"output");
        boolean bl = hasAnyFilter = hasInputFilter || hasOutputFilter;
        if (!hasAnyFilter) {
            return MethodResult.of((Object[])new Object[]{null, "NO_FILTER"});
        }
        GenericFilter<?> inputFilter = null;
        GenericFilter<?> outputFilter = null;
        if (hasInputFilter) {
            ObjectLuaTable inputFilterTable = new ObjectLuaTable(filterTable.getTable("input"));
            parsedFilter = GenericFilter.parseGeneric(inputFilterTable);
            if (parsedFilter.rightPresent()) {
                return MethodResult.of((Object[])new Object[]{null, parsedFilter.getRight()});
            }
            inputFilter = parsedFilter.getLeft();
        }
        if (hasOutputFilter) {
            ObjectLuaTable outputFilterTable = new ObjectLuaTable(filterTable.getTable("output"));
            parsedFilter = GenericFilter.parseGeneric(outputFilterTable);
            if (parsedFilter.rightPresent()) {
                return MethodResult.of((Object[])new Object[]{null, parsedFilter.getRight()});
            }
            outputFilter = parsedFilter.getLeft();
        }
        if ((pattern = RSApi.findPatternFromFilters(this.getNetwork(), inputFilter, outputFilter)).rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, pattern.getRight()});
        }
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)this.getNetwork().getComponent(AutocraftingNetworkComponent.class);
        return MethodResult.of((Object)RSApi.parsePattern(pattern.getLeft(), autocrafting));
    }
}

