/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.core.localization.Tooltips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.pedroksl.advanced_ae.client.widgets.UpgradeState;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.items.armors.PoweredItem;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.ae2addonlib.api.IGridLinkedItem;

public interface IUpgradeableItem
extends IGridLinkedItem {
    public List<UpgradeType> getPossibleUpgrades();

    default public List<UpgradeType> getAppliedUpgrades(ItemStack stack) {
        ArrayList<UpgradeType> appliedUpgrades = new ArrayList<UpgradeType>();
        for (UpgradeType upgrade : this.getPossibleUpgrades()) {
            if (!this.hasUpgrade(stack, upgrade)) continue;
            appliedUpgrades.add(upgrade);
        }
        return appliedUpgrades;
    }

    default public List<UpgradeType> getPassiveUpgrades(ItemStack itemStack) {
        ArrayList<UpgradeType> abilityList = new ArrayList<UpgradeType>();
        this.getAppliedUpgrades(itemStack).forEach(up -> {
            if (up.applicationType == UpgradeType.ApplicationType.PASSIVE || up.applicationType == UpgradeType.ApplicationType.BUFF) {
                abilityList.add((UpgradeType)((Object)up));
            }
        });
        return abilityList;
    }

    default public boolean isUpgradeEnabled(ItemStack stack, UpgradeType upgrade) {
        return (Boolean)stack.getOrDefault(AAEComponents.UPGRADE_TOGGLE.get((Object)upgrade), (Object)false);
    }

    default public boolean isUpgradePowered(ItemStack stack, UpgradeType upgrade) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return energy != null && energy.getEnergyStored() >= upgrade.getCost();
    }

    default public boolean isUpgradeEnabledAndPowered(ItemStack stack, UpgradeType upgrade) {
        return this.isUpgradeEnabled(stack, upgrade) && this.isUpgradePowered(stack, upgrade);
    }

    default public boolean isUpgradeAllowed(UpgradeType type) {
        return this.getPossibleUpgrades().contains((Object)type);
    }

    default public boolean hasUpgrade(ItemStack stack, UpgradeType type) {
        return stack.has(AAEComponents.UPGRADE_TOGGLE.get((Object)type));
    }

    default public UpgradeState getUpgradeState(ItemStack stack, UpgradeType type) {
        if (!this.hasUpgrade(stack, type)) {
            return null;
        }
        boolean toggle = (Boolean)stack.getOrDefault(AAEComponents.UPGRADE_TOGGLE.get((Object)type), (Object)true);
        int value = (Integer)stack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)type), (Object)0);
        List filter = (List)stack.get(AAEComponents.UPGRADE_FILTER.get((Object)type));
        if (type.getExtraSettings() != UpgradeType.ExtraSettings.NONE) {
            boolean extra = (Boolean)stack.getOrDefault(AAEComponents.UPGRADE_EXTRA.get((Object)type), (Object)true);
            return new UpgradeState(type, toggle, value, extra, filter);
        }
        return new UpgradeState(type, toggle, value, true, filter);
    }

    default public List<UpgradeState> getAllUpgradeStates(ItemStack stack) {
        ArrayList<UpgradeState> states = new ArrayList<UpgradeState>();
        for (UpgradeType type : this.getAppliedUpgrades(stack)) {
            UpgradeState state = this.getUpgradeState(stack, type);
            if (state == null) continue;
            states.add(state);
        }
        return states;
    }

    default public boolean applyUpgrade(ItemStack stack, UpgradeType type) {
        if (!this.isUpgradeAllowed(type) || this.hasUpgrade(stack, type)) {
            return false;
        }
        this.getAppliedUpgrades(stack).add(type);
        stack.set(AAEComponents.UPGRADE_TOGGLE.get((Object)type), (Object)true);
        stack.set(AAEComponents.UPGRADE_VALUE.get((Object)type), (Object)type.getSettings().maxValue);
        stack.set(AAEComponents.UPGRADE_FILTER.get((Object)type), new ArrayList());
        if (type.getExtraSettings() != UpgradeType.ExtraSettings.NONE) {
            stack.set(AAEComponents.UPGRADE_EXTRA.get((Object)type), (Object)true);
        }
        return true;
    }

    default public boolean removeUpgrade(ItemStack stack, UpgradeType type) {
        if (this.getAppliedUpgrades(stack).contains((Object)type)) {
            stack.remove(AAEComponents.UPGRADE_TOGGLE.get((Object)type));
            stack.remove(AAEComponents.UPGRADE_VALUE.get((Object)type));
            stack.remove(AAEComponents.UPGRADE_FILTER.get((Object)type));
            this.getAppliedUpgrades(stack).remove((Object)type);
            return true;
        }
        return false;
    }

    default public boolean toggleUpgrade(ItemStack stack, UpgradeType type) {
        return this.toggleUpgrade(stack, type, null);
    }

    default public boolean toggleUpgrade(ItemStack stack, UpgradeType type, Player player) {
        DataComponentType<Boolean> component;
        Boolean value;
        if (this.hasUpgrade(stack, type) && (value = (Boolean)stack.get(component = AAEComponents.UPGRADE_TOGGLE.get((Object)type))) != null) {
            stack.set(AAEComponents.UPGRADE_TOGGLE.get((Object)type), (Object)(value == false ? 1 : 0));
            if (player != null) {
                MutableComponent id = Component.translatable((String)((QuantumUpgradeBaseItem)type.item().asItem()).getDescriptionId());
                MutableComponent msg = id.withStyle(Tooltips.NORMAL_TOOLTIP_TEXT);
                if (!value.booleanValue()) {
                    msg.append((Component)Component.literal((String)" ON").withStyle(Tooltips.GREEN));
                } else {
                    msg.append((Component)Component.literal((String)" OFF").withStyle(Tooltips.RED));
                }
                player.displayClientMessage((Component)msg, true);
            }
            return true;
        }
        if (player != null) {
            MutableComponent id = Component.translatable((String)((QuantumUpgradeBaseItem)type.item().asItem()).getDescriptionId());
            player.displayClientMessage((Component)AAEText.UpgradeNotInstalledMessage.text(new Object[]{id}), true);
        }
        return false;
    }

    default public void tickUpgrades(Level level, Player player, ItemStack stack) {
        for (UpgradeType upgrade : this.getAppliedUpgrades(stack)) {
            if (upgrade.applicationType == UpgradeType.ApplicationType.PASSIVE && this.isUpgradeEnabled(stack, upgrade) && upgrade.ability != null) {
                if (upgrade.ability.execute(level, player, stack)) {
                    this.consumeEnergy(player, stack, upgrade);
                }
            } else if (upgrade.applicationType == UpgradeType.ApplicationType.BUFF && this.isUpgradeEnabled(stack, upgrade)) {
                this.consumeEnergy(player, stack, upgrade);
            }
            if (upgrade != UpgradeType.FLIGHT || !player.getAbilities().flying) continue;
            this.consumeEnergy(player, stack, upgrade);
        }
    }

    default public void consumeEnergy(Player player, ItemStack stack, UpgradeType upgrade) {
        this.consumeEnergy(player, stack, upgrade.getCost());
    }

    default public void consumeEnergy(Player player, ItemStack stack, int amount) {
        if (player.isCreative()) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem item2 = (PoweredItem)item;
            PowerMultiplier multi = PowerMultiplier.CONFIG;
            item2.extractAEPower(stack, multi.multiply((double)amount), Actionable.MODULATE);
        } else {
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energy != null) {
                energy.extractEnergy(amount, false);
            }
        }
    }
}

