/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client.widgets;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.style.ScreenStyle;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.pedroksl.ae2addonlib.client.widgets.CompositeWidgetContainer;
import net.pedroksl.ae2addonlib.client.widgets.HexColorInput;
import net.pedroksl.ae2addonlib.client.widgets.HueSlider;
import net.pedroksl.ae2addonlib.client.widgets.SaturationValuePicker;
import net.pedroksl.ae2addonlib.util.Colors;

public class ColorPicker
extends CompositeWidgetContainer {
    private static final int HUE_SLIDER_HEIGHT = 10;
    private static final int PREVIEW_ROW_HEIGHT = 10;
    private static final int HEX_ROW_HEIGHT = 10;
    private static final int WIDGET_SPACING = 3;
    private static final int PADDING = 2;
    private static final int HEX_LABEL_WIDTH = 23;
    private float hue;
    private float saturation;
    private float value;
    private int color;
    private UpdateTrigger updateTrigger = null;
    private final HueSlider hueSlider;
    private final SaturationValuePicker saturationValuePicker;
    private final HexColorInput hexInput;

    public ColorPicker(BiConsumer<String, ICompositeWidget> addWidget, int color, ScreenStyle style, String id) {
        super(addWidget, style, id);
        Colors.HSV hsv = Colors.ofRgb(color).hsv();
        this.color = color;
        this.hue = hsv.hue();
        this.saturation = hsv.saturation();
        this.value = hsv.value();
        Point hueSliderPosition = new Point(0, 0);
        this.hueSlider = new HueSlider(hsv.hue(), hue -> this.setHue(hue.floatValue()));
        this.hueSlider.setSize(this.width, 10);
        this.add(hueSliderPosition, this.hueSlider);
        Point saturationValuePickerPosition = new Point(0, 13);
        this.saturationValuePicker = new SaturationValuePicker(hsv.hue(), hsv.saturation(), hsv.value(), this::setSaturationAndValue);
        this.saturationValuePicker.setSize(this.width, this.height - 10 - 10 - 10 - 9 - 1);
        this.add(saturationValuePickerPosition, this.saturationValuePicker);
        Point hexInputPosition = new Point(21, this.height - 10 - 2);
        this.hexInput = new HexColorInput(style, Minecraft.getInstance().font, 0, 0, this.width - 23 + 2, 10, this::setColor);
        this.add(hexInputPosition, (AbstractWidget)this.hexInput);
        this.hexInput.setColor(color);
    }

    public Colors color() {
        return Colors.ofHsv(this.hue, this.saturation, this.value);
    }

    private void setHue(float hue) {
        if (this.updateTrigger == null) {
            this.updateTrigger = UpdateTrigger.SLIDERS;
        }
        this.hue = hue / 360.0f;
        if (this.updateTrigger == UpdateTrigger.SLIDERS) {
            this.color = Colors.ofHsv(this.hue, this.saturation, this.value).argb();
            this.hexInput.setColor(this.color);
            this.updateTrigger = null;
        } else {
            this.hueSlider.setValue(this.hue * 360.0f);
        }
        this.saturationValuePicker.setHue(this.hue);
    }

    private void setSaturationAndValue(float saturation, float value) {
        if (this.updateTrigger == null) {
            this.updateTrigger = UpdateTrigger.SLIDERS;
        }
        this.saturation = saturation;
        this.value = value;
        if (this.updateTrigger == UpdateTrigger.SLIDERS) {
            this.color = Colors.ofHsv(this.hue, this.saturation, this.value).argb();
            this.hexInput.setColor(this.color);
            this.updateTrigger = null;
        } else {
            this.saturationValuePicker.setValues(this.saturation, this.value);
        }
    }

    private void setColor(int value) {
        this.updateTrigger = UpdateTrigger.HEX_CODE;
        Colors.HSV hsv = Colors.ofRgb(value).hsv();
        this.setHue(hsv.hue() * 360.0f);
        this.setSaturationAndValue(hsv.saturation(), hsv.value());
        this.color = Colors.ofHsv(this.hue, this.saturation, this.value).argb();
        this.updateTrigger = null;
    }

    public void setColorAndUpdate(int value) {
        if (this.color == value) {
            return;
        }
        this.setColor(value);
        this.hexInput.setColor(this.color);
    }

    @Override
    public void updateBeforeRender() {
        super.updateBeforeRender();
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        super.drawBackgroundLayer(guiGraphics, bounds, mouse);
        Point pos = this.style.resolve(bounds);
        int minX = pos.getX();
        int minY = pos.getY() + this.height - 10 - 10 - 3 - 1;
        guiGraphics.fill(minX - 1, minY - 1, minX + this.width + 1, minY + 10 + 1, Colors.DARK_GRAY_BLUE.rgb());
        guiGraphics.fill(minX, minY, minX + this.width, minY + 10, this.color);
        guiGraphics.drawString(Minecraft.getInstance().font, "Hex:", pos.getX(), pos.getY() + this.height - 10, Colors.DARK_GRAY_BLUE.rgb(), false);
    }

    private static enum UpdateTrigger {
        SLIDERS,
        HEX_CODE;

    }
}

