/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client.screens;

import appeng.api.orientation.RelativeSide;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.ae2addonlib.client.widgets.AddonActionButton;
import net.pedroksl.ae2addonlib.client.widgets.AddonActionItems;
import net.pedroksl.ae2addonlib.client.widgets.IActionEnum;
import net.pedroksl.ae2addonlib.client.widgets.OutputDirectionButton;
import net.pedroksl.ae2addonlib.gui.OutputDirectionMenu;

public class OutputDirectionScreen
extends AEBaseScreen<OutputDirectionMenu> {
    private static final int BUTTON_WIDTH = 18;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_TOP_OFFSET = 6;
    private static final int BUTTON_LEFT_OFFSET = 7;
    private static final int BUTTON_OFFSET = 2;
    private final List<OutputDirectionButton> buttons = new ArrayList<OutputDirectionButton>();
    private static final Map<RelativeSide, Point> BUTTON_POSITION = OutputDirectionScreen.makeButtonPositionMap();

    public OutputDirectionScreen(OutputDirectionMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        for (RelativeSide side : RelativeSide.values()) {
            Point pos = BUTTON_POSITION.get(side);
            OutputDirectionButton button = new OutputDirectionButton(this.leftPos + pos.getX(), this.topPos + pos.getY(), 18, 20, this::buttonPressed);
            button.setSide(side);
            this.buttons.add(button);
            this.addRenderableWidget((GuiEventListener)button);
        }
        AESubScreen.addBackButton((ISubMenu)menu, (String)"back", (WidgetContainer)this.widgets);
        AddonActionButton clearBtn = new AddonActionButton((IActionEnum)AddonActionItems.CLEAR, menu::clearSides);
        clearBtn.setHalfSize(true);
        clearBtn.setDisableBackground(true);
        this.widgets.add("clearAll", (AbstractWidget)clearBtn);
    }

    protected void init() {
        super.init();
        for (OutputDirectionButton button : this.buttons) {
            RelativeSide side = button.getSide();
            if (side == null) continue;
            Point pos = BUTTON_POSITION.get(button.getSide());
            button.setPosition(this.leftPos + pos.getX(), this.topPos + pos.getY());
        }
    }

    public void update(Set<RelativeSide> sides) {
        for (OutputDirectionButton button : this.buttons) {
            RelativeSide side = button.getSide();
            if (side == null) continue;
            button.setEnabled(sides.contains(side));
        }
    }

    protected void updateBeforeRender() {
        for (OutputDirectionButton button : this.buttons) {
            RelativeSide side = button.getSide();
            if (side == null) continue;
            Point pos = BUTTON_POSITION.get(side);
            button.setPosition(this.leftPos + pos.getX(), this.topPos + pos.getY());
            ItemStack item = ((OutputDirectionMenu)this.getMenu()).getAdjacentBlock(side);
            button.setItemStack(item);
        }
        super.updateBeforeRender();
    }

    private static Map<RelativeSide, Point> makeButtonPositionMap() {
        HashMap<RelativeSide, Point> map = new HashMap<RelativeSide, Point>(6);
        map.put(RelativeSide.FRONT, new Point(27, 28));
        map.put(RelativeSide.BACK, new Point(47, 50));
        map.put(RelativeSide.TOP, new Point(27, 6));
        map.put(RelativeSide.RIGHT, new Point(7, 28));
        map.put(RelativeSide.BOTTOM, new Point(27, 50));
        map.put(RelativeSide.LEFT, new Point(47, 28));
        return map;
    }

    private void buttonPressed(Button b) {
        OutputDirectionButton button;
        RelativeSide side;
        if (b instanceof OutputDirectionButton && (side = (button = (OutputDirectionButton)b).getSide()) != null) {
            ((OutputDirectionMenu)this.getMenu()).updateSideStatus(button.getSide());
        }
    }
}

