/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.io.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.javadoctor.spec.ClassJavadoc;
import net.neoforged.javadoctor.spec.DocReferences;
import net.neoforged.javadoctor.spec.JavadocEntry;
import net.neoforged.javadoctor.spec.JavadoctorInformation;

public class GsonJDocIO {
    private static final Type M_S_E = new TypeToken<Map<String, JavadocEntry>>(){}.getType();
    private static final Type M_S_J = new TypeToken<Map<String, ClassJavadoc>>(){}.getType();
    private static final Type M_S_LS = new TypeToken<Map<String, List<String>>>(){}.getType();
    public static final JsonDeserializer<ClassJavadoc> JAVADOC_READER = (json, typeOfT, context) -> {
        if (!json.isJsonObject()) {
            throw new JsonIOException("Expected json object but found " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        JavadocEntry jdoc = null;
        if (obj.has("clazz")) {
            jdoc = (JavadocEntry)context.deserialize(obj.get("clazz"), (Type)((Object)JavadocEntry.class));
        }
        Map fields = null;
        if (obj.has("fields")) {
            fields = (Map)context.deserialize(obj.get("fields"), M_S_E);
        }
        Map methods = null;
        if (obj.has("methods")) {
            methods = (Map)context.deserialize(obj.get("methods"), M_S_E);
        }
        Map innerClasses = null;
        if (obj.has("innerClasses")) {
            innerClasses = (Map)context.deserialize(obj.get("innerClasses"), M_S_J);
        }
        return new ClassJavadoc(jdoc, methods, fields, innerClasses);
    };
    public static final JsonDeserializer<JavadocEntry> ENTRY_READER = (json, typeOfT, context) -> {
        if (!json.isJsonObject()) {
            throw new JsonIOException("Expected json object but found " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        String jdoc = null;
        if (obj.has("doc")) {
            jdoc = obj.get("doc").getAsString();
        }
        Map tags = null;
        if (obj.has("tags")) {
            tags = (Map)context.deserialize(obj.get("tags"), M_S_LS);
        }
        String[] parameters = null;
        if (obj.has("parameters")) {
            parameters = (String[])context.deserialize(obj.get("parameters"), (Type)((Object)String[].class));
        }
        String[] typeParameters = null;
        if (obj.has("typeParameters")) {
            typeParameters = (String[])context.deserialize(obj.get("typeParameters"), (Type)((Object)String[].class));
        }
        return new JavadocEntry(jdoc, tags, parameters, typeParameters);
    };
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)ClassJavadoc.class), JAVADOC_READER).registerTypeAdapter((Type)((Object)JavadocEntry.class), ENTRY_READER).create();

    public static JavadoctorInformation read(Gson gson, JsonObject object) {
        if (object.has("javadoctorSpec")) {
            int spec = object.get("javadoctorSpec").getAsInt();
            object.remove("javadoctorSpec");
            if (spec == 1) {
                return new JavadoctorInformation(new DocReferences(new HashMap<String, String>()), gson.fromJson((JsonElement)object, new TypeToken<Map<String, ClassJavadoc>>(){}));
            }
            if (spec == 2) {
                return gson.fromJson((JsonElement)object, JavadoctorInformation.class);
            }
            throw new UnsupportedOperationException("Cannot read javadocs of spec: " + spec);
        }
        return gson.fromJson((JsonElement)object, JavadoctorInformation.class);
    }

    public static JsonObject write(Gson gson, JavadoctorInformation docs) {
        JsonObject object = gson.toJsonTree(docs).getAsJsonObject();
        object.addProperty("javadoctorSpec", 2);
        return object;
    }
}

