/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.platform.mac.CFUtil;

@ThreadSafe
public final class MacPowerSource
extends AbstractPowerSource {
    private static final CoreFoundation CF = CoreFoundation.INSTANCE;
    private static final IOKit IO = IOKit.INSTANCE;

    public MacPowerSource(String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, PowerSource.CapacityUnits capacityUnits, int n, int n2, int n3, int n4, String string3, LocalDate localDate, String string4, String string5, double d7) {
        super(string, string2, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string3, localDate, string4, string5, d7);
    }

    public static List<PowerSource> getPowerSources() {
        Object object;
        Object object2;
        Object object3 = "unknown";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = -1.0;
        double d4 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        PowerSource.CapacityUnits capacityUnits = PowerSource.CapacityUnits.RELATIVE;
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        int n4 = -1;
        String string = "unknown";
        LocalDate localDate = null;
        Object object4 = "unknown";
        Object object5 = "unknown";
        double d5 = 0.0;
        IOKit.IOService iOService = IOKitUtil.getMatchingService("AppleSmartBattery");
        if (iOService != null) {
            object2 = iOService.getStringProperty("DeviceName");
            if (object2 != null) {
                object3 = object2;
            }
            if ((object2 = iOService.getStringProperty("Manufacturer")) != null) {
                object4 = object2;
            }
            if ((object2 = iOService.getStringProperty("BatterySerialNumber")) != null) {
                object5 = object2;
            }
            if ((object = iOService.getIntegerProperty("ManufactureDate")) != null) {
                int n5 = (Integer)object & 0x1F;
                int n6 = (Integer)object >> 5 & 0xF;
                int n7 = (Integer)object >> 9 & 0x7F;
                localDate = LocalDate.of(1980 + n7, n6, n5);
            }
            if ((object = iOService.getIntegerProperty("DesignCapacity")) != null) {
                n3 = (Integer)object;
            }
            if ((object = iOService.getIntegerProperty("MaxCapacity")) != null) {
                n2 = (Integer)object;
            }
            if ((object = iOService.getIntegerProperty("CurrentCapacity")) != null) {
                n = (Integer)object;
            }
            capacityUnits = PowerSource.CapacityUnits.MAH;
            object = iOService.getIntegerProperty("TimeRemaining");
            if (object != null) {
                d = (double)((Integer)object).intValue() * 60.0;
            }
            if ((object = iOService.getIntegerProperty("CycleCount")) != null) {
                n4 = (Integer)object;
            }
            if ((object = iOService.getIntegerProperty("Temperature")) != null) {
                d5 = (double)((Integer)object).intValue() / 100.0;
            }
            if ((object = iOService.getIntegerProperty("Voltage")) != null) {
                d3 = (double)((Integer)object).intValue() / 1000.0;
            }
            if ((object = iOService.getIntegerProperty("Amperage")) != null) {
                d4 = ((Integer)object).intValue();
            }
            d2 = d3 * d4;
            Boolean bl4 = iOService.getBooleanProperty("ExternalConnected");
            if (bl4 != null) {
                bl = bl4;
            }
            if ((bl4 = iOService.getBooleanProperty("IsCharging")) != null) {
                bl2 = bl4;
            }
            bl3 = !bl2;
            iOService.release();
        }
        object2 = IO.IOPSCopyPowerSourcesInfo();
        object = IO.IOPSCopyPowerSourcesList((CoreFoundation.CFTypeRef)object2);
        int n8 = ((CoreFoundation.CFArrayRef)object).getCount();
        double d6 = IO.IOPSGetTimeRemainingEstimate();
        CoreFoundation.CFStringRef cFStringRef = CoreFoundation.CFStringRef.createCFString("Name");
        CoreFoundation.CFStringRef cFStringRef2 = CoreFoundation.CFStringRef.createCFString("Is Present");
        CoreFoundation.CFStringRef cFStringRef3 = CoreFoundation.CFStringRef.createCFString("Current Capacity");
        CoreFoundation.CFStringRef cFStringRef4 = CoreFoundation.CFStringRef.createCFString("Max Capacity");
        ArrayList<PowerSource> arrayList = new ArrayList<PowerSource>(n8);
        for (int i = 0; i < n8; ++i) {
            CoreFoundation.CFBooleanRef cFBooleanRef;
            Pointer pointer = ((CoreFoundation.CFArrayRef)object).getValueAtIndex(i);
            CoreFoundation.CFTypeRef cFTypeRef = new CoreFoundation.CFTypeRef();
            cFTypeRef.setPointer(pointer);
            CoreFoundation.CFDictionaryRef cFDictionaryRef = IO.IOPSGetPowerSourceDescription((CoreFoundation.CFTypeRef)object2, cFTypeRef);
            Pointer pointer2 = cFDictionaryRef.getValue(cFStringRef2);
            if (pointer2 == null || 0 == CF.CFBooleanGetValue(cFBooleanRef = new CoreFoundation.CFBooleanRef(pointer2))) continue;
            pointer2 = cFDictionaryRef.getValue(cFStringRef);
            String string2 = CFUtil.cfPointerToString(pointer2);
            double d7 = 0.0;
            if (cFDictionaryRef.getValueIfPresent(cFStringRef3, null)) {
                pointer2 = cFDictionaryRef.getValue(cFStringRef3);
                CoreFoundation.CFNumberRef cFNumberRef = new CoreFoundation.CFNumberRef(pointer2);
                d7 = cFNumberRef.intValue();
            }
            double d8 = 1.0;
            if (cFDictionaryRef.getValueIfPresent(cFStringRef4, null)) {
                pointer2 = cFDictionaryRef.getValue(cFStringRef4);
                CoreFoundation.CFNumberRef cFNumberRef = new CoreFoundation.CFNumberRef(pointer2);
                d8 = cFNumberRef.intValue();
            }
            double d9 = Math.min(1.0, d7 / d8);
            arrayList.add(new MacPowerSource(string2, (String)object3, d9, d6, d, d2, d3, d4, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string, localDate, (String)object4, (String)object5, d5));
        }
        cFStringRef2.release();
        cFStringRef.release();
        cFStringRef3.release();
        cFStringRef4.release();
        ((CoreFoundation.CFTypeRef)object).release();
        ((CoreFoundation.CFTypeRef)object2).release();
        return arrayList;
    }
}

